/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config.schema;

import growthcraft.core.shared.block.BlockKey;
import growthcraft.core.shared.config.schema.ICommentable;
import growthcraft.core.shared.config.schema.IValidatable;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class BlockKeySchema
implements ICommentable,
IValidatable {
    public String comment;
    public String mod_id;
    public String name;
    public int meta;

    public BlockKeySchema(String pmod_id, String pname, int pmeta) {
        this.mod_id = pmod_id;
        this.name = pname;
        this.meta = pmeta;
        this.comment = "";
    }

    public BlockKeySchema(Block block, int pmeta) {
        ResourceLocation resloc = block.getRegistryName();
        this.mod_id = resloc.func_110624_b();
        this.name = resloc.func_110623_a();
        this.meta = pmeta;
        this.comment = block.func_149732_F();
    }

    public BlockKeySchema(BlockKey blockKey) {
        this(blockKey.block, blockKey.meta);
    }

    public BlockKeySchema() {
        this.comment = "";
    }

    public Block getBlock() {
        if (this.mod_id != null && this.name != null) {
            return Block.func_149684_b((String)(this.mod_id + ":" + this.name));
        }
        return null;
    }

    public BlockKey toBlockKey() {
        Block block = this.getBlock();
        if (block != null) {
            return new BlockKey(block, this.meta);
        }
        return null;
    }

    @Override
    public void setComment(String comm) {
        this.comment = comm;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isValid() {
        return this.getBlock() != null;
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }

    public String toString() {
        return String.format("Schema<BlockKey>(mod_id: '%s', name: '%s', meta: %d)", this.mod_id, this.name, this.meta);
    }
}

