/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config.description;

import growthcraft.core.shared.config.description.IDescribable;
import java.util.List;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class Describer {
    private Describer() {
    }

    public static void getDescription(List<String> list, Object obj) {
        if (obj instanceof IDescribable) {
            ((IDescribable)obj).getDescription(list);
        }
    }

    public static void getPotionEffectDescription(List<String> list, PotionEffect pe) {
        if (pe == null) {
            return;
        }
        String s = I18n.func_74838_a((String)pe.func_76453_d()).trim();
        Potion potion = pe.func_188419_a();
        if (potion != null && potion.func_76398_f()) {
            s = TextFormatting.RED + s;
        }
        if (pe.func_76458_c() > 0) {
            s = s + " " + I18n.func_74838_a((String)("potion.potency." + pe.func_76458_c())).trim();
        }
        if (pe.func_76459_b() > 20) {
            s = s + "" + TextFormatting.GRAY + " (" + Potion.func_188410_a((PotionEffect)pe, (float)pe.func_76459_b()) + ")";
        }
        list.add(s);
    }

    public static void addAllPrefixed(String prefix, List<String> dest, List<String> src) {
        for (String str : src) {
            dest.add(prefix + str);
        }
    }

    public static void addAllIndented(List<String> dest, List<String> src) {
        Describer.addAllPrefixed("  ", dest, src);
    }

    public static void compactDescription(String head, List<String> dest, List<String> src) {
        if (src.size() > 0) {
            if (src.size() == 1) {
                String line = src.get(0);
                dest.add(head + " " + line);
            } else {
                dest.add(head);
                Describer.addAllIndented(dest, src);
            }
        }
    }
}

