/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config;

import growthcraft.core.shared.config.GrowthcraftConfiguration;

public class GrowthcraftCoreConfig
extends GrowthcraftConfiguration {
    public static final String CATEGORY_NAME_WORLDGEN = "worldgen";
    public static final int BOTTLE_CAPACITY = 250;
    private static final String CATEGORY_BOOZE = "Booze/Effects";
    private boolean blockSaltOreWorldGen = true;
    private int blockSaltOreMinHeight = 10;
    private int blockSaltOreMaxHeight = 64;
    private int blockSaltOreChanceToSpawn = 5;
    private boolean hidePoisonedBooze = true;

    @Override
    protected void initGeneralConfig() {
        super.initGeneralConfig();
        this.initWorldGenCategory();
        this.initBoozeCategory();
    }

    private void initBoozeCategory() {
        this.hidePoisonedBooze = this.getConfiguration().getBoolean("hidePoisoned", CATEGORY_BOOZE, this.hidePoisonedBooze, "Should purposely poisoned booze have its effect hidden?");
    }

    private void initWorldGenCategory() {
        this.blockSaltOreChanceToSpawn = this.getConfiguration().getInt("blockSaltOreChanceToSpawn", CATEGORY_NAME_WORLDGEN, this.blockSaltOreChanceToSpawn, 0, 10, "Chance for Rock Salt Ore to generate in the world.");
        this.blockSaltOreMaxHeight = this.getConfiguration().getInt("blockSaltOreMaxHeight", CATEGORY_NAME_WORLDGEN, this.blockSaltOreMaxHeight, 0, 256, "Maximum height to generate rock salt ore. This must be higher than blockSaltOreMinHeight. ");
        this.blockSaltOreMinHeight = this.getConfiguration().getInt("blockSaltOreMinHeight", CATEGORY_NAME_WORLDGEN, this.blockSaltOreMinHeight, 0, 256, "Minimum height to generate rock salt ore. This must be lower then blockSaltOreMinHeight.");
        this.blockSaltOreWorldGen = this.getConfiguration().getBoolean("blockSaltOreWorldGen", CATEGORY_NAME_WORLDGEN, this.blockSaltOreWorldGen, "Set to false to disable worldgen of rock salt ores.");
    }

    public boolean getHidePoisonedBooze() {
        return this.hidePoisonedBooze;
    }

    public boolean getBlockSaltOreWorldGen() {
        return this.blockSaltOreWorldGen;
    }

    public int getBlockSaltOreMinHeight() {
        return this.blockSaltOreMinHeight;
    }

    public int getBlockSaltOreMaxHeight() {
        return this.blockSaltOreMaxHeight;
    }

    public int getBlockSaltOreChanceToSpawn() {
        return this.blockSaltOreChanceToSpawn;
    }
}

