/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.client.gui;

import growthcraft.core.shared.client.gui.TooltipManager;
import growthcraft.core.shared.client.gui.widget.WidgetManager;
import growthcraft.core.shared.fluids.UnitFormatter;
import growthcraft.core.shared.utils.ColorUtils;
import growthcraft.core.shared.utils.Rectangle;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GrowthcraftGuiContainer<C extends Container, T extends TileEntity>
extends GuiContainer {
    protected T tileEntity;
    protected ResourceLocation guiResource;
    protected TooltipManager tooltipManager;
    protected WidgetManager widgets;

    public GrowthcraftGuiContainer(ResourceLocation res, C container, T te) {
        super(container);
        this.guiResource = res;
        this.tileEntity = te;
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public int getGuiX() {
        return (this.field_146294_l - this.field_146999_f) / 2;
    }

    public int getGuiY() {
        return (this.field_146295_m - this.field_147000_g) / 2;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public void setZLevel(float z) {
        this.field_73735_i = z;
    }

    public void getItemRendererZLevel(float z) {
        this.field_146296_j.field_77023_b = z;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tooltipManager = new TooltipManager(this);
        this.widgets = new WidgetManager(this);
    }

    public void drawHoveringText(List<String> l, int x, int y, FontRenderer renderer) {
        super.drawHoveringText(l, x, y, renderer);
    }

    public void func_146283_a(List<String> l, int x, int y) {
        this.drawHoveringText(l, x, y, this.field_146289_q);
    }

    public void func_73733_a(int x, int y, int w, int h, int color1, int color2) {
        super.func_73733_a(x, y, w, h, color1, color2);
    }

    public void bindTexture(ResourceLocation res) {
        this.field_146297_k.func_110434_K().func_110577_a(res);
    }

    public void bindGuiTexture() {
        this.bindTexture(this.guiResource);
    }

    public void drawFluidStack(int x, int y, int wp, int hp, int width, int height, int amount, FluidStack fluidstack) {
        TextureAtlasSprite fluidTexture;
        if (fluidstack == null) {
            return;
        }
        Fluid fluid = fluidstack.getFluid();
        int color = fluid.getColor();
        if (fluid != null && (fluidTexture = this.field_146297_k.func_147117_R().getTextureExtry(fluid.getStill().toString())) != null) {
            try {
                this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                float[] argb = ColorUtils.getFloat4ARGB(color);
                GL11.glColor4f((float)argb[1], (float)argb[2], (float)argb[3], (float)1.0f);
                this.func_175175_a(x + this.field_147003_i, y + this.field_147009_r + (height - amount), fluidTexture, width, amount);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void drawTank(int w, int h, int wp, int hp, int width, int height, int amount, FluidTank tank) {
        FluidStack fluidstack = tank.getFluid();
        int fluidHeight = tank.getFluidAmount() * height / tank.getCapacity();
        this.drawFluidStack(w, h, wp, hp, width, height, fluidHeight, fluidstack);
    }

    protected void addFluidTooltips(FluidStack fluid, List<String> tooltip) {
        if (fluid == null) {
            return;
        }
        if (fluid.amount <= 0) {
            return;
        }
        tooltip.add(fluid.getLocalizedName());
        String s = UnitFormatter.fluidModifier(fluid.getFluid());
        if (s != null) {
            tooltip.add(s);
        }
    }

    public void addTooltipIndex(String handle, Rectangle r) {
        this.tooltipManager.addTooltipIndex(handle, r);
    }

    public void addTooltipIndex(String handle, int x, int y, int w, int h) {
        this.tooltipManager.addTooltipIndex(handle, x, y, w, h);
    }

    protected void drawInventoryName(int mx, int my) {
        if (this.tileEntity instanceof IInventory) {
            IInventory inv = (IInventory)this.tileEntity;
            String invName = inv.func_70005_c_();
            String s = inv.func_145818_k_() ? invName : I18n.func_135052_a((String)invName, (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        }
    }

    protected void drawWidgets(int mx, int my) {
        this.widgets.draw(mx, my);
    }

    protected void drawWidgetsForeground(int mx, int my) {
        this.widgets.drawForeground(mx, my);
    }

    protected void drawGuiPanel(int mx, int my) {
        this.func_73729_b(this.getGuiX(), this.getGuiY(), 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146976_a(float f, int mx, int my) {
        this.bindGuiTexture();
        this.drawGuiPanel(mx, my);
        this.drawWidgets(mx, my);
        this.bindGuiTexture();
    }

    protected void drawTooltips(int mx, int my) {
        this.tooltipManager.draw(mx, my);
        this.func_191948_b(mx, my);
    }

    protected void func_146979_b(int mx, int my) {
        super.func_146979_b(mx, my);
        this.drawInventoryName(mx, my);
        this.drawWidgetsForeground(mx, my);
    }

    public void func_73863_a(int mx, int my, float par) {
        super.func_73863_a(mx, my, par);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        this.drawTooltips(mx, my);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    public void addTooltips(String handle, List<String> tips) {
    }
}

