/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import growthcraft.core.shared.io.nbt.INBTSerializableContext;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public class AbstractClassRegistry<T extends INBTSerializableContext> {
    private BiMap<String, Class<? extends T>> effects = HashBiMap.create();

    public Class<? extends T> getClass(@Nonnull String name) {
        return (Class)this.effects.get((Object)name);
    }

    public String getName(@Nonnull Class<?> klass) {
        return (String)this.effects.inverse().get(klass);
    }

    public void register(@Nonnull String name, @Nonnull Class<? extends T> klass) {
        if (this.effects.containsKey((Object)name)) {
            Class<T> effect = this.getClass(name);
            throw new ClassRegisteredException("Cannot register " + klass + ", Effect " + effect + " is already registered to " + name);
        }
        this.effects.put((Object)name, klass);
    }

    public T loadObjectFromNBT(@Nonnull NBTTagCompound data, @Nonnull String name) {
        NBTTagCompound effectData = data.func_74775_l(name);
        String factoryName = effectData.func_74779_i("__name__");
        Class<T> klass = this.getClass(factoryName);
        INBTSerializableContext instance = null;
        try {
            instance = (INBTSerializableContext)klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to create a new instance of an illegal class " + klass, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to create a new instance of " + klass + ", because lack of permissions", e);
        }
        instance.readFromNBT(data, name);
        return (T)instance;
    }

    public static class ClassRegisteredException
    extends RuntimeException {
        public static final long serialVersionUID = 1L;

        public ClassRegisteredException(@Nonnull String msg) {
            super(msg);
        }

        public ClassRegisteredException() {
        }
    }
}

