/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.culturing.user;

import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.processing.culturing.user.UserCultureRecipe;
import growthcraft.cellar.shared.processing.culturing.user.UserCultureRecipes;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.config.AbstractUserJSONConfig;
import growthcraft.core.shared.config.schema.FluidStackSchema;
import growthcraft.core.shared.config.schema.ItemKeySchema;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UserCultureRecipesConfig
extends AbstractUserJSONConfig {
    private final UserCultureRecipes defaultRecipes = new UserCultureRecipes();
    private UserCultureRecipes recipes;

    public void addDefault(UserCultureRecipe recipe) {
        this.defaultRecipes.data.add(recipe);
    }

    public void addDefault(FluidStack inp, ItemStack stack, float heat, int time) {
        this.addDefault(new UserCultureRecipe(new FluidStackSchema(inp), new ItemKeySchema(stack), heat, time));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserCultureRecipes)this.gson.fromJson((Reader)reader, UserCultureRecipes.class);
    }

    private void addRecipe(UserCultureRecipe recipe) {
        if (recipe == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Invalid recipe");
            return;
        }
        if (recipe.output_item == null || recipe.output_item.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Invalid output_item for recipe {%s}", (Object)recipe);
            return;
        }
        if (recipe.input_fluid == null || recipe.input_fluid.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Invalid input_fluid {%s}", (Object)recipe);
            return;
        }
        FluidStack inputFluidStack = recipe.input_fluid.asFluidStack();
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding user culturing recipe {%s}", (Object)recipe);
        CellarRegistry.instance().culturing().addRecipe(inputFluidStack, recipe.output_item.asStack(), recipe.required_heat, recipe.time);
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding %d user culturing recipes.", (Object)this.recipes.data.size());
                for (UserCultureRecipe recipe : this.recipes.data) {
                    this.addRecipe(recipe);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft_cellar").error("Recipes data is invalid!");
            }
        }
    }
}

