/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import growthcraft.cellar.common.block.BlockFruitPresser;
import growthcraft.cellar.common.block.BlockRotatableCellarContainer;
import growthcraft.cellar.common.tileentity.TileEntityFruitPress;
import growthcraft.cellar.shared.init.GrowthcraftCellarBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFruitPress
extends BlockRotatableCellarContainer {
    public BlockFruitPress(String unlocalizedName) {
        super(Material.field_151575_d);
        this.setTileEntityType(TileEntityFruitPress.class);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_cellar", unlocalizedName));
    }

    private Block getPresserBlock() {
        return GrowthcraftCellarBlocks.fruitPresser.getBlock();
    }

    @Override
    public void doRotateBlock(World world, BlockPos pos, IBlockState state, EnumFacing side) {
        IBlockState statePresser = world.func_180495_p(pos.func_177984_a());
        EnumFacing pressFacing = (EnumFacing)state.func_177229_b((IProperty)TYPE_ROTATION);
        BlockFruitPresser.Orient presserOrient = (BlockFruitPresser.Orient)((Object)statePresser.func_177229_b(BlockFruitPresser.TYPE_ORIENT));
        pressFacing = pressFacing == EnumFacing.NORTH || pressFacing == EnumFacing.SOUTH ? EnumFacing.EAST : EnumFacing.SOUTH;
        presserOrient = BlockFruitPresser.Orient.fromFacing(pressFacing);
        world.func_180501_a(pos, state.func_177226_a((IProperty)TYPE_ROTATION, (Comparable)pressFacing), 2);
        world.func_180501_a(pos.func_177984_a(), statePresser.func_177226_a(BlockFruitPresser.TYPE_ORIENT, (Comparable)((Object)presserOrient)), 2);
    }

    private void placePresserFor(World world, BlockPos pos, EnumFacing facing) {
        IBlockState statePresser = this.getPresserBlock().func_176223_P().func_177226_a(BlockFruitPresser.TYPE_ORIENT, (Comparable)((Object)BlockFruitPresser.Orient.fromFacing(facing)));
        world.func_180501_a(pos.func_177984_a(), statePresser, 2);
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)TYPE_ROTATION);
        this.placePresserFor(world, pos, facing);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing facing = this.setOrientWhenPlacing(worldIn, pos, state, placer, false);
        this.placePresserFor(worldIn, pos, facing);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && this.presserIsAbove((IBlockAccess)world, pos)) {
            world.func_175655_b(pos.func_177984_a(), false);
            TileEntity te = world.func_175625_s(pos.func_177984_a());
            if (te != null) {
                te.func_145843_s();
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay((IBlockAccess)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)TYPE_ROTATION);
        BlockFruitPresser.Orient orient = BlockFruitPresser.Orient.fromFacing(facing);
        if (orient == BlockFruitPresser.Orient.TOEAST) {
            return side == EnumFacing.EAST || side == EnumFacing.WEST;
        }
        if (orient == BlockFruitPresser.Orient.TOSOUTH) {
            return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
        }
        return this.isNormalCube(state, world, pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean presserIsAbove(IBlockAccess world, BlockPos pos) {
        return this.getPresserBlock() == world.func_180495_p(pos.func_177984_a()).func_177230_c();
    }

    public boolean canBlockStay(IBlockAccess world, BlockPos pos) {
        return this.presserIsAbove(world, pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        if (pos.func_177956_o() >= 255) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_185896_q() && super.func_176196_c(world, pos) && super.func_176196_c(world, pos.func_177984_a());
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityFruitPress te = (TileEntityFruitPress)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return te.getFluidAmountScaled(15, 0);
        }
        return 0;
    }
}

