/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import growthcraft.cellar.common.block.BlockCorkLeaves;
import growthcraft.cellar.common.block.BlockCorkLog;
import growthcraft.cellar.shared.init.GrowthcraftCellarBlocks;
import growthcraft.core.shared.block.GrowthcraftBlockLog;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCorkLogStripped
extends GrowthcraftBlockLog {
    private static final AxisAlignedBB AABB_FULL_BLOCK = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockCorkLogStripped(String unlocalizedName) {
        super("growthcraft_cellar", unlocalizedName);
        this.func_149675_a(true);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_FULL_BLOCK;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockCorkLogStripped.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_FULL_BLOCK);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (this.canChangeToLog(worldIn, pos) && rand.nextInt(100) <= 50) {
            worldIn.func_175656_a(pos, GrowthcraftCellarBlocks.blockCorkLog.getDefaultState());
        }
    }

    private boolean canChangeToLog(World worldIn, BlockPos pos) {
        return this.lookForValidCorkBlocks(worldIn, pos, EnumFacing.UP, 7) && this.lookForValidCorkBlocks(worldIn, pos, EnumFacing.DOWN, 7);
    }

    private boolean lookForValidCorkBlocks(World worldIn, BlockPos pos, EnumFacing facing, int range) {
        for (int i = 1; i <= range; ++i) {
            IBlockState state = facing == EnumFacing.UP ? worldIn.func_180495_p(pos.func_177981_b(i)) : worldIn.func_180495_p(pos.func_177979_c(i));
            if (state.func_177230_c() instanceof BlockCorkLeaves || state.func_177230_c() instanceof BlockGrass || state.func_177230_c() instanceof BlockDirt) {
                return true;
            }
            if (state.func_177230_c() instanceof BlockCorkLog || state.func_177230_c() instanceof BlockCorkLogStripped) continue;
            return false;
        }
        return false;
    }
}

