/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.tileentity.device;

import growthcraft.bees.common.lib.config.BeesRegistry;
import growthcraft.bees.common.lib.config.IFlowerBlockEntry;
import growthcraft.bees.common.tileentity.TileEntityBeeBox;
import growthcraft.bees.shared.config.GrowthcraftBeesConfig;
import growthcraft.core.shared.tileentity.device.DeviceBase;
import growthcraft.core.shared.utils.RandomUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class DeviceBeeBox
extends DeviceBase {
    public List<List> flowerList = new ArrayList<List>();
    private final float honeyCombSpawnRate = GrowthcraftBeesConfig.beeBoxHoneyCombSpawnRate;
    private final float honeySpawnRate = GrowthcraftBeesConfig.beeBoxHoneySpawnRate;
    private final float beeSpawnRate = GrowthcraftBeesConfig.beeBoxBeeSpawnRate;
    private final float flowerSpawnRate = GrowthcraftBeesConfig.beeBoxFlowerSpawnRate;
    private final int flowerRadius = GrowthcraftBeesConfig.beeBoxFlowerRadius;
    private final float bonus = GrowthcraftBeesConfig.beeBoxBonusMultiplier;
    private Random random = new Random();
    private int bonusTime;

    public DeviceBeeBox(TileEntityBeeBox te) {
        super(te);
    }

    protected TileEntityBeeBox getParentTile() {
        if (this.parent instanceof TileEntityBeeBox) {
            return (TileEntityBeeBox)this.parent;
        }
        return null;
    }

    public int getBonusTime(int t) {
        return this.bonusTime;
    }

    public void setBonusTime(int t) {
        this.bonusTime = t;
    }

    public boolean hasBonus() {
        return this.bonusTime > 0;
    }

    private boolean canDoWork() {
        BlockPos posUp = this.parent.func_174877_v().func_177984_a();
        if (this.getWorld().func_175727_C(posUp)) {
            return false;
        }
        return this.getWorld().func_175671_l(posUp) >= 7;
    }

    private boolean isBlockFlower(IBlockState blockState) {
        return BeesRegistry.instance().isBlockFlower(blockState);
    }

    private List<List> gatherFlowersInRadius(World world, BlockPos pos, int checkSize, List<List> list) {
        int i = pos.func_177958_n() - (checkSize - 1) / 2;
        int k = pos.func_177952_p() - (checkSize - 1) / 2;
        BlockPos.MutableBlockPos fpos = new BlockPos.MutableBlockPos();
        for (int xLoop = -checkSize; xLoop < checkSize; ++xLoop) {
            for (int yLoop = -checkSize; yLoop < checkSize; ++yLoop) {
                fpos.func_181079_c(i + xLoop, pos.func_177956_o(), k + yLoop);
                if (world.func_175623_d((BlockPos)fpos)) continue;
                IBlockState flower = world.func_180495_p((BlockPos)fpos);
                Block flowerBlock = flower.func_177230_c();
                if (flower == null || !this.isBlockFlower(flower)) continue;
                list.add(Arrays.asList(flower, flowerBlock.func_176201_c(flower)));
            }
        }
        return list;
    }

    private float calcGrowthRate(World world, BlockPos pos) {
        int checkSize = 5;
        int i = pos.func_177958_n() - 2;
        int k = pos.func_177952_p() - 2;
        float f = 1.0f;
        BlockPos.MutableBlockPos fpos = new BlockPos.MutableBlockPos();
        for (int loopx = -5; loopx < 5; ++loopx) {
            for (int loopz = -5; loopz < 5; ++loopz) {
                fpos.func_181079_c(i + loopx, pos.func_177956_o(), k + loopz);
                IBlockState flower = world.func_180495_p((BlockPos)fpos);
                Block flowerBlock = flower.func_177230_c();
                IBlockState soil = world.func_180495_p(fpos.func_177977_b());
                float f1 = 0.0f;
                if (soil.func_177230_c() == Blocks.field_150349_c) {
                    f1 = 0.36f;
                    if (this.isBlockFlower(flower)) {
                        f1 = 1.08f;
                    }
                } else if (flower.func_177230_c() == Blocks.field_150457_bL && flower.func_177229_b((IProperty)BlockFlowerPot.field_176443_b) != BlockFlowerPot.EnumFlowerType.EMPTY) {
                    f1 = 0.72f;
                }
                f += (f1 /= 4.0f);
            }
        }
        TileEntityBeeBox te = this.getParentTile();
        if (te != null) {
            int bees = te.countBees();
            float div = 2.0f - 0.015625f * (float)bees;
            f /= div;
            if (te.hasBonus()) {
                f *= this.bonus;
            }
        }
        return f;
    }

    public float getGrowthRate() {
        return this.calcGrowthRate(this.getWorld(), this.parent.func_174877_v());
    }

    public void update() {
        if (this.bonusTime > 0) {
            --this.bonusTime;
        }
    }

    protected int honeyCombBias() {
        TileEntityBeeBox te = this.getParentTile();
        int empty = te.countEmptyCombs();
        int filled = te.countHoney();
        return filled - empty;
    }

    public void updateTick() {
        int spawnRate;
        TileEntityBeeBox te = this.getParentTile();
        if (!this.canDoWork() || !te.hasBees()) {
            return;
        }
        BlockPos pos = te.func_174877_v();
        float f = this.getGrowthRate();
        if (!te.hasMaxBees() && this.random.nextInt((int)(this.beeSpawnRate / f) + 1) == 0) {
            te.spawnBee();
        }
        int maxCombs = te.getHoneyCombMax();
        int curCombs = te.countCombs();
        if (te.countHoney() < maxCombs) {
            int biasSpawn;
            boolean shouldFill;
            int bias = this.honeyCombBias();
            boolean bl = shouldFill = bias < 0;
            if (bias != 0 && curCombs <= maxCombs && (biasSpawn = Math.min(MathHelper.func_76130_a((int)bias), 6)) > 0 && this.random.nextInt(biasSpawn) == 0) {
                boolean bl2 = shouldFill = !shouldFill;
            }
            if (shouldFill) {
                if (this.random.nextInt((int)(this.honeySpawnRate / f) + 1) == 0) {
                    te.fillHoneyComb();
                }
            } else if (this.random.nextInt((int)(this.honeyCombSpawnRate / f) + 1) == 0) {
                te.spawnHoneyComb();
            }
        }
        f = 7.48f / (2.0f - 0.015625f * (float)te.countBees());
        if (te.hasBonus()) {
            f *= this.bonus;
        }
        if (this.random.nextInt(spawnRate = (int)(this.flowerSpawnRate / f) + 1) == 0) {
            int checkSize = this.flowerRadius;
            this.flowerList.clear();
            this.gatherFlowersInRadius(this.getWorld(), pos, checkSize, this.flowerList);
            if (!this.flowerList.isEmpty()) {
                BlockPos randomPos = new BlockPos(pos.func_177958_n() + this.random.nextInt(checkSize * 2) - checkSize, pos.func_177956_o(), pos.func_177952_p() + this.random.nextInt(checkSize * 2) - checkSize);
                List randomList = RandomUtils.sample(this.random, this.flowerList);
                if (randomList != null) {
                    IBlockState blockState = (IBlockState)randomList.get(0);
                    Block block = blockState.func_177230_c();
                    int meta = (Integer)randomList.get(1);
                    IFlowerBlockEntry entry = BeesRegistry.instance().getFlowerBlockEntry(block, meta);
                    if (entry != null && entry.canPlaceAt(this.getWorld(), randomPos)) {
                        this.getWorld().func_180501_a(randomPos, block.func_176203_a(meta), 2);
                    }
                }
            }
        }
    }

    public void updateClientTick() {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.bonusTime = data.func_74762_e("bonus_time");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("bonus_time", this.bonusTime);
    }

    @Override
    public boolean readFromStream(ByteBuf buf) {
        super.readFromStream(buf);
        this.bonusTime = buf.readInt();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf buf) {
        super.writeToStream(buf);
        buf.writeInt(this.bonusTime);
        return false;
    }
}

