/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.util;

import com.charles445.rltweaker.util.IntObjPredicate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import meldexun.reflectionutil.ReflectionField;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTUtil {
    private static final ReflectionField<Map<String, NBTBase>> NBTTagCompound_tagMap = new ReflectionField(NBTTagCompound.class, "field_74784_a", "tagMap");
    private static final ReflectionField<List<NBTBase>> NBTTagList_tagList = new ReflectionField(NBTTagList.class, "field_74747_a", "tagList");

    public static boolean remove(NBTTagCompound compound, String key) {
        return NBTTagCompound_tagMap.get(compound).remove(key) != null;
    }

    public static boolean clear(NBTTagCompound compound) {
        if (compound.func_82582_d()) {
            return false;
        }
        NBTTagCompound_tagMap.get(compound).clear();
        return true;
    }

    public static <T extends NBTBase> boolean forEach(NBTTagCompound compound, Predicate<T> predicate) {
        return NBTUtil.forEach(compound, (String k, T v) -> predicate.test(v));
    }

    public static <T extends NBTBase> boolean forEach(NBTTagCompound compound, BiPredicate<String, T> predicate) {
        return NBTTagCompound_tagMap.get(compound).entrySet().stream().filter(entry -> predicate.test((String)entry.getKey(), (Object)entry.getValue())).count() > 0L;
    }

    public static <T extends NBTBase> boolean removeIf(NBTTagCompound compound, Predicate<T> predicate) {
        return NBTUtil.removeIf(compound, (String k, T v) -> predicate.test(v));
    }

    public static <T extends NBTBase> boolean removeIf(NBTTagCompound compound, BiPredicate<String, T> predicate) {
        return NBTTagCompound_tagMap.get(compound).entrySet().removeIf(entry -> predicate.test((String)entry.getKey(), (Object)entry.getValue()));
    }

    public static <T extends NBTBase> boolean removeIf(NBTTagCompound compound, String key, Predicate<T> predicate) {
        NBTBase tag = compound.func_74781_a(key);
        if (tag != null && predicate.test(tag)) {
            compound.func_82580_o(key);
            return true;
        }
        return false;
    }

    public static boolean clear(NBTTagList list) {
        if (list.func_82582_d()) {
            return false;
        }
        NBTTagList_tagList.get(list).clear();
        return true;
    }

    public static <T extends NBTBase> boolean removeIf(NBTTagList list, Predicate<T> predicate) {
        return NBTTagList_tagList.get(list).removeIf(predicate);
    }

    public static <T extends NBTBase> boolean removeIf(NBTTagList list, IntObjPredicate<T> predicate) {
        AtomicInteger index = new AtomicInteger();
        return NBTUtil.removeIf(list, (T element) -> predicate.test(index.getAndIncrement(), element));
    }
}

