/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.hook.optifine.fastshaderloading;

import com.charles445.rltweaker.hook.optifine.OptifineConfig;
import com.charles445.rltweaker.hook.optifine.fastshaderloading.ExtShaderOption;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import meldexun.reflectionutil.ReflectionField;
import net.minecraft.util.StringUtils;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.config.ShaderMacros;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderOptionSwitch;
import net.optifine.shaders.config.ShaderOptionSwitchConst;
import net.optifine.shaders.config.ShaderOptionVariable;
import net.optifine.shaders.config.ShaderOptionVariableConst;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.util.StrUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ShaderPackParserHook {
    private static final Pattern PATTERN_INCLUDE = Pattern.compile("^\\s*#include\\s+\"([A-Za-z0-9_/\\.]+)\".*$");
    private static final Set<String> setConstNames = (Set)new ReflectionField(ShaderPackParser.class, "setConstNames", "").get(null);
    private static final Map<String, Pair<List<String>, List<String>>> file2lines_includes = new ConcurrentHashMap<String, Pair<List<String>, List<String>>>();
    private static final Map<Pair<String, String>, Boolean> option_file2used = new ConcurrentHashMap<Pair<String, String>, Boolean>();
    private static final Map<Pair<String, String>, Object> option_file2lock = new ConcurrentHashMap<Pair<String, String>, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShaderOption[] parseShaderPackOptions(IShaderPack shaderPack, String[] programs, List<Integer> dimensions) {
        if (shaderPack == null) {
            return new ShaderOption[0];
        }
        try {
            ShaderOption[] shaderOptionArray = (ShaderOption[])Stream.concat(Stream.of("/shaders"), dimensions.stream().map(dimension -> "/shaders/world" + dimension)).flatMap(dir -> Arrays.stream(programs).flatMap(program -> Stream.of(dir + "/" + program + ".vsh", dir + "/" + program + ".fsh"))).collect(Collectors.toList()).parallelStream().reduce(new ConcurrentHashMap(), (m, s) -> {
                ShaderPackParserHook.parseShaderOptions(shaderPack, s, s, m);
                return m;
            }, (m1, m2) -> m1).values().stream().map(ExtShaderOption.class::cast).map(ExtShaderOption::collectPaths).sorted(Comparator.comparing(ShaderOption::getName, String.CASE_INSENSITIVE_ORDER)).toArray(ShaderOption[]::new);
            return shaderOptionArray;
        }
        catch (Exception e) {
            OptifineConfig.dbg(e.getClass().getName() + ": " + e.getMessage());
            ShaderOption[] shaderOptionArray = new ShaderOption[]{};
            return shaderOptionArray;
        }
        finally {
            file2lines_includes.clear();
            option_file2lock.clear();
            option_file2used.clear();
        }
    }

    private static void parseShaderOptions(IShaderPack shaderPack, String parent, String path, Map<String, ShaderOption> shaderOptions) {
        Pair<List<String>, List<String>> lines_includes = ShaderPackParserHook.readFile(shaderPack, path);
        for (String line : (List)lines_includes.getLeft()) {
            ShaderPackParserHook.parseShaderOption(shaderPack, parent, path, line, shaderOptions);
        }
        for (String include : (List)lines_includes.getRight()) {
            ShaderPackParserHook.parseShaderOptions(shaderPack, parent, include, shaderOptions);
        }
    }

    private static Pair<List<String>, List<String>> readFile(IShaderPack shaderPack, String path) {
        return file2lines_includes.computeIfAbsent(path, k -> {
            try (InputStream in = shaderPack.getResourceAsStream(path);){
                if (in == null) {
                    Pair pair = Pair.of(Collections.emptyList(), Collections.emptyList());
                    return pair;
                }
                ArrayList<String> lines = new ArrayList<String>();
                ArrayList<String> includes = new ArrayList<String>();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.US_ASCII));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        Matcher includeMatcher = PATTERN_INCLUDE.matcher(line);
                        if (includeMatcher.matches()) {
                            includes.add(ShaderPackParserHook.parseInclude(path, includeMatcher.group(1)));
                            continue;
                        }
                        lines.add(line);
                    }
                }
                Pair pair = Pair.of(lines, includes);
                return pair;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static String parseInclude(String file, String target) {
        return target.startsWith("/") ? "/shaders" + target : ShaderPackParserHook.getParent(file) + "/" + target;
    }

    private static String getParent(String file) {
        int i = file.lastIndexOf("/");
        return i >= 0 ? file.substring(0, i) : "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseShaderOption(IShaderPack shaderPack, String parent, String path, String line, Map<String, ShaderOption> shaderOptions) {
        ShaderOption shaderOption = ShaderPackParserHook.parseShaderOption(line, parent);
        if (shaderOption == null) {
            return;
        }
        if (shaderOption.getName().startsWith(ShaderMacros.getPrefixMacro())) {
            return;
        }
        if (shaderOption.checkUsed() && !ShaderPackParserHook.isUsed(shaderPack, parent, shaderOption)) {
            return;
        }
        if (shaderOption != null) {
            ShaderOption shaderOption1 = shaderOptions.putIfAbsent(shaderOption.getName(), shaderOption);
            if (shaderOption1 != null) {
                if (!Objects.equals(shaderOption1.getValueDefault(), shaderOption.getValueDefault())) {
                    OptifineConfig.warn("Ambiguous shader option: " + shaderOption.getName());
                    OptifineConfig.warn(" - in " + ((ExtShaderOption)shaderOption1).getPathSet() + ": " + shaderOption1.getValueDefault());
                    OptifineConfig.warn(" - in " + ((ExtShaderOption)shaderOption).getPathSet() + ": " + shaderOption.getValueDefault());
                    shaderOption1.setEnabled(false);
                }
                if (!StringUtils.func_151246_b((String)shaderOption.getDescription()) && StringUtils.func_151246_b((String)shaderOption1.getDescription())) {
                    ShaderOption shaderOption2 = shaderOption1;
                    synchronized (shaderOption2) {
                        if (StringUtils.func_151246_b((String)shaderOption1.getDescription())) {
                            shaderOption1.setDescription(shaderOption.getDescription());
                        }
                    }
                }
                ((ExtShaderOption)shaderOption1).addPath(StrUtils.removePrefix((String)parent, (String)"/shaders/"));
            } else {
                ((ExtShaderOption)shaderOption).addPath(StrUtils.removePrefix((String)parent, (String)"/shaders/"));
            }
        }
    }

    private static ShaderOption parseShaderOption(String line, String shader) {
        ShaderOption shaderOption = ShaderOptionSwitch.parseOption((String)line, (String)shader);
        if (shaderOption == null) {
            shaderOption = ShaderOptionVariable.parseOption((String)line, (String)shader);
        }
        if (shaderOption != null) {
            return shaderOption;
        }
        shaderOption = ShaderOptionSwitchConst.parseOption((String)line, (String)shader);
        if (shaderOption == null) {
            shaderOption = ShaderOptionVariableConst.parseOption((String)line, (String)shader);
        }
        if (shaderOption != null) {
            return setConstNames.contains(shaderOption.getName()) ? shaderOption : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUsed(IShaderPack shaderPack, String path, ShaderOption shaderOption) {
        Pair key = Pair.of((Object)shaderOption.getName(), (Object)path);
        Boolean result = option_file2used.get(key);
        if (result == null) {
            Object object = option_file2lock.computeIfAbsent((Pair<String, String>)key, k -> new Object());
            synchronized (object) {
                result = option_file2used.get(key);
                if (result == null) {
                    result = ShaderPackParserHook.isUsed0(shaderPack, path, shaderOption);
                    option_file2used.put((Pair<String, String>)key, result);
                }
            }
        }
        return result;
    }

    private static boolean isUsed0(IShaderPack shaderPack, String path, ShaderOption shaderOption) {
        Pair<List<String>, List<String>> lines_includes = ShaderPackParserHook.readFile(shaderPack, path);
        for (String include : (List)lines_includes.getRight()) {
            if (!ShaderPackParserHook.isUsed(shaderPack, include, shaderOption)) continue;
            return true;
        }
        for (String line : (List)lines_includes.getLeft()) {
            if (!shaderOption.isUsedInLine(line)) continue;
            return true;
        }
        return false;
    }
}

