/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.hook.optifine.fastshaderloading;

import com.charles445.rltweaker.hook.optifine.fastshaderloading.CharPredicate;

class FastStringReader {
    private final String input;
    private int pos;
    private final int len;

    FastStringReader(String input) {
        this.input = input;
        this.len = input.length();
    }

    boolean read(char expected) {
        return this.pos < this.len && this.input.charAt(this.pos++) == expected;
    }

    boolean read(CharSequence expected) {
        for (int i = 0; i < expected.length(); ++i) {
            if (this.pos < this.len && this.input.charAt(this.pos++) == expected.charAt(i)) continue;
            return false;
        }
        return true;
    }

    boolean readOptional(char expected) {
        if (this.pos < this.len && this.input.charAt(this.pos) == expected) {
            ++this.pos;
            return true;
        }
        return false;
    }

    boolean readOptional(CharSequence expected) {
        if (expected.length() > this.len - this.pos) {
            return false;
        }
        for (int i = 0; i < expected.length(); ++i) {
            if (this.input.charAt(this.pos + i) == expected.charAt(i)) continue;
            return false;
        }
        this.pos += expected.length();
        return true;
    }

    int readWhile(CharPredicate predicate) {
        int start = this.pos;
        while (this.pos < this.len && predicate.test(this.input.charAt(this.pos))) {
            ++this.pos;
        }
        return this.pos - start;
    }

    String readMatching(CharPredicate predicate) {
        int start = this.pos;
        while (this.pos < this.len && predicate.test(this.input.charAt(this.pos))) {
            ++this.pos;
        }
        return this.input.substring(start, this.pos);
    }

    String readAll() {
        String result = this.input.substring(this.pos, this.len);
        this.pos = this.len;
        return result;
    }

    boolean endReached() {
        return this.pos >= this.len;
    }

    static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    static boolean isWord(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '-';
    }
}

