/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.config.json.JsonLoader;
import com.charles445.rltweaker.network.IServerMessageReceiver;
import com.charles445.rltweaker.network.MessageReskillableLockSkill;
import com.charles445.rltweaker.network.ServerMessageHandler;
import com.charles445.rltweaker.reflect.ReskillableReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.ReflectUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ReskillableHandler {
    private static final Path FILE_NAME = Paths.get("reskillableTransmutation.json", new String[0]);
    private static final Type TYPE = new TypeToken<HashMultimap<String, Transmutation>>(){}.getType();
    private ReskillableReflect reflector;
    private ManualSubscriber manualSubscriber;

    public ReskillableHandler() {
        block3: {
            try {
                this.reflector = new ReskillableReflect();
                this.manualSubscriber = new ManualSubscriber(this.reflector);
                if (ModConfig.server.reskillable.toggleableTraits) {
                    ServerMessageHandler.registerMessage(MessageReskillableLockSkill.class, new LockSkillReceiver());
                    this.manualSubscriber.subscribeToggleableTraits();
                }
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup ReskillableHandler!", (Throwable)e);
                ErrorUtil.logSilent("Reskillable Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public static void loadConfig() {
        Multimap transmutations;
        if (!Loader.isModLoaded((String)"reskillable")) {
            return;
        }
        if (!ModConfig.server.reskillable.enabled) {
            return;
        }
        if (!ModConfig.server.reskillable.customTransmutation) {
            return;
        }
        try {
            transmutations = (Multimap)JsonLoader.readJson(RLTweaker.jsonDirectory.resolve(FILE_NAME), TYPE, ReskillableHandler.getDefaults());
        }
        catch (IOException e) {
            RLTweaker.logger.error("Failed to load reskillable transmutations config", (Throwable)e);
            return;
        }
        Object reskillableHandler = RLTweaker.handlers.get("reskillable");
        if (reskillableHandler instanceof ReskillableHandler) {
            ((ReskillableHandler)reskillableHandler).registerTransmutations((Multimap<String, Transmutation>)transmutations);
        }
    }

    private static HashMultimap<String, Transmutation> getDefaults() {
        HashMultimap defaults = HashMultimap.create();
        defaults.put((Object)"minecraft:stick", (Object)new Transmutation(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P()));
        return defaults;
    }

    public void registerTransmutations(Multimap<String, Transmutation> transmutations) {
        transmutations.asMap().forEach((k, v) -> {
            Item activator = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(k));
            if (activator == null) {
                RLTweaker.logger.warn("Skipping unregistered item in registerTransmutations: " + k);
                return;
            }
            for (Transmutation transmutation : v) {
                try {
                    this.reflector.addEntryToReagent(activator, transmutation.input, transmutation.output);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RLTweaker.logger.error("Invocation error in registerTransmutations", (Throwable)e);
                    ErrorUtil.logSilent("Reskillable registerTransmutations Invoke Failure");
                }
            }
        });
    }

    public static class ManualSubscriber {
        private ReskillableReflect reflector;
        private boolean canReflectOldElenai = false;
        private Class c_oldElenai_WalljumpProvider;
        private Field f_oldElenai_WalljumpProvider_WALLJUMP_CAP;
        private Class c_oldElenai_IWalljump;
        private Method m_oldElenai_IWalljump_set;
        private Class c_oldElenai_LedgegrabProvider;
        private Field f_oldElenai_LedgegrabProvider_LEDGEGRAB_CAP;
        private Class c_oldElenai_ILedgegrab;
        private Method m_oldElenai_ILedgegrab_set;
        private Class c_oldElenai_DodgeProvider;
        private Field f_oldElenai_DodgeProvider_DODGE_CAP;
        private Class c_oldElenai_IDodge;
        private Method m_oldElenai_IDodge_set;

        public ManualSubscriber(ReskillableReflect reflector) {
            this.reflector = reflector;
            try {
                this.c_oldElenai_WalljumpProvider = Class.forName("com.elenai.elenaidodge.modpacks.capability.walljump.WalljumpProvider");
                this.f_oldElenai_WalljumpProvider_WALLJUMP_CAP = ReflectUtil.findField(this.c_oldElenai_WalljumpProvider, "WALLJUMP_CAP");
                this.c_oldElenai_IWalljump = Class.forName("com.elenai.elenaidodge.modpacks.capability.walljump.IWalljump");
                this.m_oldElenai_IWalljump_set = ReflectUtil.findMethod(this.c_oldElenai_IWalljump, "set");
                this.c_oldElenai_LedgegrabProvider = Class.forName("com.elenai.elenaidodge.modpacks.capability.ledgegrab.LedgegrabProvider");
                this.f_oldElenai_LedgegrabProvider_LEDGEGRAB_CAP = ReflectUtil.findField(this.c_oldElenai_LedgegrabProvider, "LEDGEGRAB_CAP");
                this.c_oldElenai_ILedgegrab = Class.forName("com.elenai.elenaidodge.modpacks.capability.ledgegrab.ILedgegrab");
                this.m_oldElenai_ILedgegrab_set = ReflectUtil.findMethod(this.c_oldElenai_ILedgegrab, "set");
                this.c_oldElenai_DodgeProvider = Class.forName("com.elenai.elenaidodge.modpacks.capability.trait.TraitProvider");
                this.f_oldElenai_DodgeProvider_DODGE_CAP = ReflectUtil.findField(this.c_oldElenai_DodgeProvider, "TRAIT_CAP");
                this.c_oldElenai_IDodge = Class.forName("com.elenai.elenaidodge.modpacks.capability.trait.ITrait");
                this.m_oldElenai_IDodge_set = ReflectUtil.findMethod(this.c_oldElenai_IDodge, "set");
                this.canReflectOldElenai = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void subscribeToggleableTraits() throws Exception {
            CompatUtil.subscribeEventManually(this.reflector.c_LockUnlockableEvent$Post, this, ReflectUtil.findMethod(this.getClass(), "onToggleableTraitLockedPost"));
        }

        @SubscribeEvent
        public void onToggleableTraitLockedPost(Object uncastedEvent) {
            if (uncastedEvent instanceof PlayerEvent) {
                PlayerEvent event = (PlayerEvent)uncastedEvent;
                try {
                    String lockedName = this.reflector.getUnlockableName(this.reflector.getUnlockableFromLockedEvent(event));
                    if (lockedName != null && event.getEntityPlayer() != null) {
                        this.synchronizeUnlockable(event.getEntityPlayer(), lockedName);
                    }
                }
                catch (Exception e) {
                    ErrorUtil.logSilent("Reskillable Toggleable Trait Post Handler");
                }
            }
        }

        public void synchronizeUnlockable(EntityPlayer player, String name) {
            switch (name) {
                case "elenaidodge.dodgetrait": {
                    this.clearOldElenaiDodgeTrait(player);
                    break;
                }
                case "elenaidodge.wallgrabtrait": {
                    this.clearOldElenaiLedgeGrabTrait(player);
                    break;
                }
                case "elenaidodge.walljumptrait": {
                    this.clearOldElenaiWallJumpTrait(player);
                    break;
                }
            }
        }

        private void clearOldElenaiDodgeTrait(EntityPlayer player) {
            if (!this.canReflectOldElenai) {
                return;
            }
            try {
                Object provided = player.getCapability((Capability)this.f_oldElenai_DodgeProvider_DODGE_CAP.get(null), null);
                this.m_oldElenai_IDodge_set.invoke(provided, false);
            }
            catch (Exception e) {
                ErrorUtil.logSilent("Reskillable Toggleable Trait Old Elenai Dodge Dodge");
            }
        }

        private void clearOldElenaiLedgeGrabTrait(EntityPlayer player) {
            if (!this.canReflectOldElenai) {
                return;
            }
            try {
                Object provided = player.getCapability((Capability)this.f_oldElenai_LedgegrabProvider_LEDGEGRAB_CAP.get(null), null);
                this.m_oldElenai_ILedgegrab_set.invoke(provided, false);
            }
            catch (Exception e) {
                ErrorUtil.logSilent("Reskillable Toggleable Trait Old Elenai Dodge Wall Grab");
            }
        }

        private void clearOldElenaiWallJumpTrait(EntityPlayer player) {
            if (!this.canReflectOldElenai) {
                return;
            }
            try {
                Object provided = player.getCapability((Capability)this.f_oldElenai_WalljumpProvider_WALLJUMP_CAP.get(null), null);
                this.m_oldElenai_IWalljump_set.invoke(provided, false);
            }
            catch (Exception e) {
                ErrorUtil.logSilent("Reskillable Toggleable Trait Old Elenai Dodge Wall Jump");
            }
        }
    }

    public class LockSkillReceiver
    implements IServerMessageReceiver {
        @Override
        public void receiveMessage(IMessage msgIn, EntityPlayer player) {
            try {
                if (msgIn instanceof MessageReskillableLockSkill) {
                    MessageReskillableLockSkill message = (MessageReskillableLockSkill)msgIn;
                    IForgeRegistry<?> SKILLS = ReskillableHandler.this.reflector.getSkillsRegistry();
                    IForgeRegistry<?> UNLOCKABLES = ReskillableHandler.this.reflector.getUnlockablesRegistry();
                    if (!SKILLS.containsKey(message.skill)) {
                        return;
                    }
                    if (!UNLOCKABLES.containsKey(message.unlockable)) {
                        return;
                    }
                    IForgeRegistryEntry skill = SKILLS.getValue(message.skill);
                    IForgeRegistryEntry unlockable = UNLOCKABLES.getValue(message.unlockable);
                    Object playerData = ReskillableHandler.this.reflector.getPlayerData(player);
                    Object skillInfo = ReskillableHandler.this.reflector.getSkillInfo(playerData, skill);
                    boolean unlocked = ReskillableHandler.this.reflector.isUnlocked(skillInfo, unlockable);
                    if (unlocked) {
                        if (ReskillableHandler.this.reflector.postLockUnlockableEventPre(player, unlockable)) {
                            return;
                        }
                        ReskillableHandler.this.reflector.lockPlayerSkill(skillInfo, unlockable, player);
                        ReskillableHandler.this.reflector.saveAndSyncPlayerData(playerData);
                        ReskillableHandler.this.reflector.postLockUnlockableEventPost(player, unlockable);
                    } else {
                        ErrorUtil.logSilent("Reskillable LockSkillReceiver Unlock Asked Lock");
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                ErrorUtil.logSilent("Reskillable LockSkillReceiver Invoke");
            }
        }
    }

    private static class Transmutation {
        private final IBlockState input;
        private final IBlockState output;

        public Transmutation(IBlockState input, IBlockState output) {
            this.input = Objects.requireNonNull(input);
            this.output = Objects.requireNonNull(output);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Transmutation)) {
                return false;
            }
            Transmutation other = (Transmutation)obj;
            return this.input.equals(other.input) && this.output.equals(other.output);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.input.hashCode();
            hash = hash * 31 + this.output.hashCode();
            return hash;
        }
    }
}

