/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.LostCitiesReflect;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LostCitiesHandler {
    private LostCitiesReflect reflector;
    private LCTerrainHandler terrainHandler;

    public LostCitiesHandler() {
        block2: {
            try {
                this.reflector = new LostCitiesReflect();
                this.terrainHandler = new LCTerrainHandler();
                MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.terrainHandler);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup LostCitiesHandler!", (Throwable)e);
                ErrorUtil.logSilent("LostCities Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public class LCTerrainHandler {
        @SubscribeEvent
        public void onDecorate(DecorateBiomeEvent.Decorate event) {
            World world = event.getWorld();
            if (world.field_72995_K) {
                return;
            }
            if (!ModConfig.server.lostcities.generationCacheCleanupEnabled) {
                return;
            }
            try {
                if (!LostCitiesHandler.this.reflector.isLostCities(world)) {
                    return;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                ErrorUtil.logSilent("LCTerrainHandler isLostCities Invocation");
                return;
            }
            Object chunkGenerator = null;
            try {
                chunkGenerator = LostCitiesHandler.this.reflector.getLostCityChunkGenerator(world);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                ErrorUtil.logSilent("LCTerrainHandler getLostCityChunkGenerator Invocation");
                return;
            }
            if (chunkGenerator == null) {
                return;
            }
            int generationCacheMaxCount = ModConfig.server.lostcities.generationCacheMaxCount;
            try {
                Map cachedPrimers = LostCitiesHandler.this.reflector.getCachedPrimers(chunkGenerator);
                if (cachedPrimers.size() >= generationCacheMaxCount) {
                    RLTweaker.logger.debug("Clearing Lost Cities cachedPrimers: " + cachedPrimers.size());
                    cachedPrimers.clear();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ErrorUtil.logSilent("LCTerrainHandler getCachedPrimers Invocation");
            }
            try {
                Map cachedHeightmaps = LostCitiesHandler.this.reflector.getCachedHeightmaps(chunkGenerator);
                if (cachedHeightmaps.size() >= generationCacheMaxCount) {
                    RLTweaker.logger.debug("Clearing Lost Cities cachedHeightmaps: " + cachedHeightmaps.size());
                    cachedHeightmaps.clear();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ErrorUtil.logSilent("LCTerrainHandler getCachedHeightmaps Invocation");
            }
        }
    }
}

