/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.LevelUpTwoReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LevelUpTwoHandler {
    LevelUpTwoReflect reflector;

    public LevelUpTwoHandler() {
        block2: {
            try {
                this.reflector = new LevelUpTwoReflect();
                CompatUtil.wrapSpecificHandler("LUStealthDamage", x$0 -> new LUStealthDamage((IEventListener)x$0), "levelup2.skills.combat.StealthDamage", "onDamage");
                CompatUtil.wrapSpecificHandler("LUSwordCrit", x$0 -> new LUSwordCrit((IEventListener)x$0), "levelup2.skills.combat.SwordCritBonus", "onHurting");
                CompatUtil.wrapSpecificHandler("LUSwordDamage", x$0 -> new LUSwordDamage((IEventListener)x$0), "levelup2.skills.combat.SwordDamageBonus", "onHurting");
                CompatUtil.wrapSpecificHandler("LUXPBonus", x$0 -> new LUXPBonus((IEventListener)x$0), "levelup2.skills.combat.XPBonusCombat", "getCombatBonus");
                CompatUtil.wrapSpecificHandler("LUStealthTarget", x$0 -> new LUStealthTarget((IEventListener)x$0), "levelup2.skills.combat.StealthBonus", "onTargetSet");
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup LevelUpTwoHandler!", (Throwable)e);
                ErrorUtil.logSilent("LevelUpTwo Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isSourceDisallowed(DamageSource source) {
        if (source == null) {
            return false;
        }
        Entity immediateSrc = source.func_76364_f();
        if (immediateSrc == null) {
            return false;
        }
        Entity trueSrc = source.func_76346_g();
        if (trueSrc == null) {
            return false;
        }
        return !ModConfig.server.leveluptwo.petsUseSkills && immediateSrc != trueSrc && immediateSrc instanceof EntityLivingBase && trueSrc instanceof EntityPlayer && !(immediateSrc instanceof EntityPlayer);
    }

    public class LUStealthTarget {
        private IEventListener handler;
        private Object skill;

        public LUStealthTarget(IEventListener handler) {
            this.handler = handler;
            this.skill = CompatUtil.getSubscriberInstance(handler);
            if (this.skill == null) {
                if (ModConfig.server.leveluptwo.stealthOverhaul) {
                    RLTweaker.logger.error("Could not find StealthBonus subscriber instance! LevelUp2 Stealth Overhaul is disabled");
                }
            } else if (!this.skill.getClass().getName().equals("levelup2.skills.combat.StealthBonus")) {
                RLTweaker.logger.error("Subscriber instance of LUStealthTarget was the wrong class!: " + this.skill.getClass().getName());
                this.skill = null;
            } else {
                RLTweaker.logger.info("Gathered subscriber instance of class: " + this.skill.getClass().getName());
            }
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onSetAttackTarget(LivingSetAttackTargetEvent event) {
            if (this.skill == null || !ModConfig.server.leveluptwo.stealthOverhaul) {
                this.handler.invoke((Event)event);
                return;
            }
            try {
                if (!LevelUpTwoHandler.this.reflector.skillIsActive(this.skill)) {
                    return;
                }
                if (event.getTarget() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityLiving && this.isLivingStealth((EntityLiving)event.getEntityLiving())) {
                    EntityPlayer player = (EntityPlayer)event.getTarget();
                    EntityLiving mob = (EntityLiving)event.getEntityLiving();
                    if (mob.func_70643_av() == player) {
                        return;
                    }
                    if (!player.func_70093_af()) {
                        return;
                    }
                    if (mob.func_142015_aE() == mob.field_70173_aa) {
                        return;
                    }
                    int skillLevel = LevelUpTwoHandler.this.reflector.getSkillLevel(player, "levelup:stealth");
                    if (skillLevel <= 0) {
                        return;
                    }
                    if ((float)MathHelper.func_76128_c((double)player.func_70068_e((Entity)mob)) > this.calculateStealthDistance(skillLevel)) {
                        mob.func_70624_b(null);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                ErrorUtil.logSilent("LevelUp2 Stealth Overhaul Invocation");
                this.handler.invoke((Event)event);
            }
        }

        private boolean isLivingStealth(EntityLiving living) {
            if (living instanceof EntityMob) {
                return true;
            }
            return LevelUpTwoHandler.this.reflector.isLycanitesAvailable() && ModConfig.server.leveluptwo.stealthOverhaulLycanites && LevelUpTwoHandler.this.reflector.canLycanitesStealth(living);
        }

        private float calculateStealthDistance(int skillLevel) {
            float base = (float)ModConfig.server.leveluptwo.stealthOverhaulBaseDistance;
            float per = (float)ModConfig.server.leveluptwo.stealthOverhaulDistancePerLevel * (float)skillLevel;
            float clamped = Math.max(0.0f, base - per);
            return clamped * clamped;
        }
    }

    public class LUXPBonus {
        private IEventListener handler;

        public LUXPBonus(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onLivingDeath(LivingDeathEvent event) {
            if (LevelUpTwoHandler.this.isSourceDisallowed(event.getSource())) {
                return;
            }
            this.handler.invoke((Event)event);
        }
    }

    public class LUSwordDamage {
        private IEventListener handler;

        public LUSwordDamage(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onLivingHurt(LivingHurtEvent event) {
            if (LevelUpTwoHandler.this.isSourceDisallowed(event.getSource())) {
                return;
            }
            this.handler.invoke((Event)event);
        }
    }

    public class LUSwordCrit {
        private IEventListener handler;

        public LUSwordCrit(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onLivingHurt(LivingHurtEvent event) {
            if (LevelUpTwoHandler.this.isSourceDisallowed(event.getSource())) {
                return;
            }
            this.handler.invoke((Event)event);
        }
    }

    public class LUStealthDamage {
        private IEventListener handler;

        public LUStealthDamage(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onLivingHurt(LivingHurtEvent event) {
            if (LevelUpTwoHandler.this.isSourceDisallowed(event.getSource())) {
                return;
            }
            this.handler.invoke((Event)event);
        }
    }
}

