/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.client.texture;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.client.texture.TextureData;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import meldexun.memoryutil.UnsafeBufferUtil;
import meldexun.memoryutil.UnsafeByteBuffer;
import meldexun.memoryutil.UnsafeUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import sun.misc.Unsafe;

public class TextureDataUtil {
    public static TextureData loadTextureData(ResourceLocation textureLocation) throws IOException {
        try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(textureLocation);){
            BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            boolean blur = false;
            boolean clamp = false;
            if (resource.func_110528_c()) {
                try {
                    TextureMetadataSection texturemetadatasection = (TextureMetadataSection)resource.func_110526_a("texture");
                    if (texturemetadatasection != null) {
                        blur = texturemetadatasection.func_110479_a();
                        clamp = texturemetadatasection.func_110480_b();
                    }
                }
                catch (RuntimeException runtimeexception) {
                    RLTweaker.logger.warn("Failed reading metadata of: {}", (Object)textureLocation, (Object)runtimeexception);
                }
            }
            UnsafeByteBuffer buffer = UnsafeBufferUtil.allocateByte(width * height * 4);
            switch (bufferedImage.getType()) {
                case 5: {
                    int i;
                    Object[] data = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                    for (i = 0; i < width * height; ++i) {
                        int c = -16777216;
                        c |= (data[i * 3 + 0] & 0xFF) << 16;
                        c |= (data[i * 3 + 1] & 0xFF) << 8;
                        buffer.putInt(i * 4, c |= (data[i * 3 + 2] & 0xFF) << 0);
                    }
                    break;
                }
                case 6: {
                    int i;
                    Object[] data = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                    for (i = 0; i < width * height; ++i) {
                        int c = UnsafeUtil.UNSAFE.getInt(data, Unsafe.ARRAY_BYTE_BASE_OFFSET + i * 4);
                        c = (c & 0xFF) << 24 | (c & 0xFF00) << 8 | (c & 0xFF0000) >>> 8 | (c & 0xFF000000) >>> 24;
                        buffer.putInt(i * 4, c);
                    }
                    break;
                }
                default: {
                    int i;
                    Object[] data = new int[width * height];
                    bufferedImage.getRGB(0, 0, width, height, (int[])data, 0, width);
                    for (i = 0; i < width * height; ++i) {
                        int c = data[i];
                        c = c & 0xFF00FF00 | (c & 0xFF) << 16 | (c & 0xFF0000) >>> 16;
                        buffer.putInt(i * 4, c);
                    }
                }
            }
            TextureData textureData = new TextureData(width, height, blur, clamp, buffer);
            return textureData;
        }
    }
}

