/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.pickupnotification;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import mod.acgaming.universaltweaks.tweaks.misc.pickupnotification.UTContainerWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class UTPickupNotificationOverlay
extends GuiScreen {
    private final List<ChangeInfo> changeEntries = Lists.newArrayList();
    private final RenderItem renderItem;
    private int hard_limit;
    private int dim;
    private int dimLoadTicks;
    private ItemStack[] previous;
    private int previousXP = -1;
    private EntityPlayer playerEntity;
    private ItemStack previousInCursor = ItemStack.field_190927_a;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new UTPickupNotificationOverlay());
    }

    private static boolean areSameishItem(ItemStack a, ItemStack b) {
        return a == b || UTPickupNotificationOverlay.isStackEmpty(a) && UTPickupNotificationOverlay.isStackEmpty(b) || ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    private static boolean isStackEmpty(ItemStack stack) {
        return stack.func_190916_E() <= 0;
    }

    private static ItemStack safeCopy(ItemStack stack) {
        return stack.func_77946_l();
    }

    private UTPickupNotificationOverlay() {
        this.renderItem = Minecraft.func_71410_x().func_175599_af();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void utPUNRenderOverlay(RenderGameOverlayEvent.Post event) {
        int align;
        int y;
        int x;
        int number;
        int rectWidth;
        if (!UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNItemAdditions && !UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNItemRemovals) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.CHAT) {
            return;
        }
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        width = (int)((double)width / UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNScaleName);
        height = (int)((double)height / UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNScaleName);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int iconSize = (int)(16.0 * UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNScaleIcon);
        int rightMargin = UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNDisplayIcon ? 2 + iconSize : 0;
        int topMargin1 = 2 + (UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNDisplayIcon ? Math.max(0, (iconSize - font.field_78288_b) / 2) : 0);
        int topMargin2 = 1 + Math.max(0, -(iconSize - font.field_78288_b) / 2);
        int lineHeight = font.field_78288_b;
        if (UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNDisplayIcon) {
            lineHeight = Math.max(2 + iconSize, lineHeight);
        }
        this.hard_limit = height / lineHeight;
        ArrayList computedStrings = Lists.newArrayList();
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            if (this.changeEntries.size() == 0) {
                return;
            }
            rectWidth = this.computeStrings(computedStrings, font);
            number = computedStrings.size();
            if (number == 0) {
                return;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNScaleName, (double)UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNScaleName, (double)1.0);
        rectWidth += rightMargin;
        int rectHeight = lineHeight * number;
        switch (UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNSnapPosition) {
            default: {
                x = width - 2 - rectWidth - UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetHorizontal;
                y = height - 2 - rectHeight - UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetVertical;
                align = 1;
                break;
            }
            case BOTTOM: {
                x = (width - rectWidth) / 2 - 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetHorizontal;
                y = height - 2 - rectHeight - UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetVertical;
                align = 0;
                break;
            }
            case BOTTOM_LEFT: {
                x = 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetHorizontal;
                y = height - 2 - rectHeight - UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetVertical;
                align = -1;
                break;
            }
            case LEFT: {
                x = 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetVertical;
                align = -1;
                break;
            }
            case TOP_LEFT: {
                x = 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetHorizontal;
                y = 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetVertical;
                align = -1;
                break;
            }
            case TOP: {
                x = (width - rectWidth) / 2 - 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetHorizontal;
                y = 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetVertical;
                align = 0;
                break;
            }
            case TOP_RIGHT: {
                x = width - 2 - rectWidth - UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetHorizontal;
                y = 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetVertical;
                align = 1;
                break;
            }
            case RIGHT: {
                x = width - 2 - rectWidth - UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetVertical;
                align = 1;
                break;
            }
            case CENTER: {
                x = (width - rectWidth) / 2 - 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNOffsetVertical;
                align = 0;
            }
        }
        if (UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNDisplayBackground) {
            UTPickupNotificationOverlay.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + rectWidth + 4), (int)(y + rectHeight + 4), (int)Integer.MIN_VALUE);
        }
        for (Triple e : computedStrings) {
            ChangeInfo change = (ChangeInfo)e.getLeft();
            String[] strings = (String[])e.getMiddle();
            int fade = (Integer)e.getRight();
            int w = 0;
            int[] widths = new int[strings.length];
            for (int n = 0; n < strings.length; ++n) {
                String str = strings[n];
                int wn = widths[n] = font.func_78256_a(str);
                w += wn;
            }
            int forcedFade = UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNFadeLimit > 0 ? fade * 255 / (UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNFadeLimit + 2) : 255;
            int ttlFade = change.ttl * 255 / UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNFadeDuration;
            int alpha = Math.min(255, Math.min(forcedFade, ttlFade));
            int color = alpha << 24 | (change.mode == ChangeMode.OBTAINED ? 0x7FFF7F : 0xFF5F5F);
            int leftMargin = 0;
            switch (align) {
                case -1: {
                    leftMargin = 2;
                    break;
                }
                case 0: {
                    leftMargin = (rectWidth - w - rightMargin) / 2;
                    break;
                }
                case 1: {
                    leftMargin = rectWidth - w - rightMargin;
                }
            }
            GlStateManager.func_179147_l();
            int wAcc = 0;
            for (int n = 0; n < strings.length; ++n) {
                font.func_175063_a(strings[n], (float)(x + leftMargin + wAcc), (float)(y + topMargin1), color);
                wAcc += widths[n];
            }
            if (UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNDisplayIcon) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(x + 2 + w + leftMargin), (float)(y + topMargin2), (float)0.0f);
                GlStateManager.func_179139_a((double)UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNScaleIcon, (double)UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNScaleIcon, (double)1.0);
                RenderHelper.func_74520_c();
                if (change.item.stack.func_77973_b() == Items.field_151062_by && change.item.stack.func_77960_j() == 42) {
                    ItemStack xpTemp = new ItemStack(Items.field_151062_by);
                    this.renderItem.func_180450_b(xpTemp, 0, 0);
                    this.renderItem.func_180453_a(font, xpTemp, 0, 0, null);
                } else {
                    this.renderItem.func_180450_b(change.item.stack, 0, 0);
                    this.renderItem.func_180453_a(font, change.item.stack, 0, 0, null);
                }
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
            y += lineHeight;
        }
        GlStateManager.func_179121_F();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void utPUNClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNItemAdditions && !UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNItemRemovals) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (player != this.playerEntity) {
            if (player.field_71069_bz != null) {
                player.field_71069_bz = new UTContainerWrapper((ContainerPlayer)player.field_71069_bz, (EntityPlayer)player, () -> {
                    this.previous = null;
                    this.dimLoadTicks = 0;
                });
                this.playerEntity = player;
            }
            this.previous = null;
        }
        if (player.field_71093_bK != this.dim) {
            this.previous = null;
            this.dimLoadTicks = 200;
            this.dim = player.field_71093_bK;
        }
        if (this.dimLoadTicks > 0) {
            this.previous = null;
            --this.dimLoadTicks;
            return;
        }
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            this.changeEntries.forEach(e -> --e.ttl);
            while (this.changeEntries.size() > this.hard_limit) {
                this.changeEntries.remove(0);
            }
            this.changeEntries.removeIf(e -> e.ttl <= 0 || e.count == 0);
        }
        if (this.previous == null || this.previous.length != player.field_71071_by.func_70302_i_()) {
            this.previous = new ItemStack[player.field_71071_by.func_70302_i_()];
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                this.previous[i] = UTPickupNotificationOverlay.safeCopy(player.field_71071_by.func_70301_a(i));
            }
            this.previousInCursor = player.field_71071_by.func_70445_o();
            return;
        }
        ArrayList changes = Lists.newArrayList();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack old = this.previous[i];
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (this.isChangeMeaningful(old, stack)) {
                changes.add(Pair.of((Object)old, (Object)stack));
            }
            this.previous[i] = stack.func_77946_l();
        }
        ItemStack stackInCursor = player.field_71071_by.func_70445_o();
        if (this.isChangeMeaningful(stackInCursor, this.previousInCursor)) {
            changes.add(Pair.of((Object)this.previousInCursor, (Object)stackInCursor));
        }
        this.previousInCursor = stackInCursor.func_77946_l();
        if (UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNExperience) {
            if (this.previousXP == -1) {
                this.previousXP = player.field_71067_cb;
            } else if (this.previousXP != player.field_71067_cb) {
                changes.add(Pair.of((Object)new ItemStack(Items.field_151062_by, this.previousXP, 42), (Object)new ItemStack(Items.field_151062_by, player.field_71067_cb, 42)));
                this.previousXP = player.field_71067_cb;
            }
        }
        if (changes.size() == 0) {
            return;
        }
        ArrayList changeList = Lists.newArrayList();
        changes.forEach(change -> {
            boolean rightEmpty;
            ItemStack left = (ItemStack)change.getLeft();
            boolean leftEmpty = left.func_190916_E() <= 0;
            ItemStack right = (ItemStack)change.getRight();
            boolean bl = rightEmpty = right.func_190916_E() <= 0;
            if (UTPickupNotificationOverlay.areSameishItem(left, right)) {
                if (!this.isBlacklisted(left)) {
                    int difference = right.func_190916_E() - left.func_190916_E();
                    if (difference > 0) {
                        this.obtainedItem(changeList, left, difference);
                    } else if (difference < 0) {
                        this.lostItem(changeList, left, -difference);
                    }
                }
            } else {
                if (!leftEmpty && !this.isBlacklisted(left)) {
                    this.lostItem(changeList, left, left.func_190916_E());
                }
                if (!rightEmpty && !this.isBlacklisted(right)) {
                    this.obtainedItem(changeList, right, right.func_190916_E());
                }
            }
        });
        changeList.removeIf(e -> e.count == 0);
        if (changeList.size() > 0) {
            List<ChangeInfo> list2 = this.changeEntries;
            synchronized (list2) {
                for (ChangeInfo info : changeList) {
                    if (info.count == 0) continue;
                    this.accumulate(this.changeEntries, info.item.stack, info.mode, info.count, false);
                }
            }
        }
    }

    private int computeStrings(List<Triple<ChangeInfo, String[], Integer>> computedStrings, FontRenderer font) {
        int rectWidth = 0;
        int itemsToShow = Math.min(Math.min(this.hard_limit, UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNSoftLimit + UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNFadeLimit), this.changeEntries.size());
        int offset = Math.max(0, this.changeEntries.size() - itemsToShow);
        int fadeOffset = this.changeEntries.size() - UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNSoftLimit - UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNFadeLimit;
        for (int i = offset; i < this.changeEntries.size(); ++i) {
            ChangeInfo change = this.changeEntries.get(i);
            String[] parts = this.getChangeStrings(change);
            int w = Arrays.stream(parts).mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).sum();
            rectWidth = Math.max(rectWidth, w);
            computedStrings.add((Triple<ChangeInfo, String[], Integer>)Triple.of((Object)change, (Object)parts, (Object)Math.min(UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNFadeLimit + 2, 1 + i - fadeOffset)));
        }
        return rectWidth;
    }

    private String[] getChangeStrings(ChangeInfo change) {
        String mode = change.mode == ChangeMode.OBTAINED ? "+" : "-";
        String s1 = String.format("%s%d", mode, change.count);
        if (UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNDisplayName) {
            String italics;
            String name = change.item.stack.func_82833_r();
            String string = italics = change.item.stack.func_82837_s() ? String.valueOf(TextFormatting.ITALIC) : "";
            if (change.item.stack.func_77973_b() == Items.field_151062_by && change.item.stack.func_77960_j() == 42) {
                name = I18n.func_135052_a((String)"msg.universaltweaks.tweaks.pickupnotification.xp", (Object[])new Object[0]);
                italics = "";
            }
            String s2 = String.format("%s%s", italics, name);
            return new String[]{s1, " ", s2};
        }
        return new String[]{s1};
    }

    private boolean isBlacklisted(ItemStack left) {
        return Arrays.asList(UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNBlacklistItem).contains(left.func_77973_b().getRegistryName().toString());
    }

    private boolean isChangeMeaningful(ItemStack a, ItemStack b) {
        if (a.func_190916_E() != b.func_190916_E()) {
            return true;
        }
        if (a == b || UTPickupNotificationOverlay.isStackEmpty(a) && UTPickupNotificationOverlay.isStackEmpty(b)) {
            return false;
        }
        if (a.func_77973_b() == b.func_77973_b() && Arrays.asList(UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNBlacklistSubitem).contains(a.func_77973_b().getRegistryName().toString())) {
            return false;
        }
        return !ItemStack.func_185132_d((ItemStack)a, (ItemStack)b);
    }

    private void obtainedItem(List<ChangeInfo> changeList, ItemStack item, int added) {
        if (added <= 0 || !UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNItemAdditions) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.OBTAINED, added, true);
    }

    private void lostItem(List<ChangeInfo> changeList, ItemStack item, int removed) {
        if (removed <= 0 || !UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNItemRemovals) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.LOST, removed, true);
    }

    private void accumulate(List<ChangeInfo> changeList, ItemStack stack, ChangeMode mode, int count, boolean isLocal) {
        ChangeInfo info;
        if (stack.func_190916_E() <= 0) {
            return;
        }
        ComparableItem name = new ComparableItem(stack);
        ChangeInfo changeInfo = info = isLocal ? (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name)).findFirst().orElse(null) : (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name) && e.mode == mode).findFirst().orElse(null);
        if (info == null) {
            info = new ChangeInfo(name, mode, count, UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNDisplayDuration);
            changeList.add(info);
            return;
        }
        if (info.mode != mode) {
            count = -count;
        }
        info.count += count;
        info.ttl = UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPUNDisplayDuration;
        if (info.count < 0) {
            info.count = -info.count;
            info.mode = info.mode == ChangeMode.LOST ? ChangeMode.OBTAINED : ChangeMode.LOST;
        }
    }

    private static class ComparableItem {
        ItemStack stack;

        ComparableItem(ItemStack stack) {
            this.stack = stack.func_77946_l();
            this.stack.func_190920_e(1);
        }

        public int hashCode() {
            return this.stack.func_77973_b().hashCode() * 31 ^ this.stack.func_77960_j();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComparableItem)) {
                return false;
            }
            ItemStack stack = ((ComparableItem)obj).stack;
            return UTPickupNotificationOverlay.areSameishItem(stack, this.stack);
        }
    }

    private static class ChangeInfo {
        final ComparableItem item;
        ChangeMode mode;
        int count;
        int ttl;

        ChangeInfo(ComparableItem item, ChangeMode mode, int count, int ttl) {
            this.item = item;
            this.mode = mode;
            this.count = count;
            this.ttl = ttl;
        }
    }

    private static enum ChangeMode {
        OBTAINED,
        LOST;

    }
}

