/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.loadsound;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="universaltweaks", value={Side.CLIENT})
public class UTLoadSound {
    public static boolean playedMenu = false;
    public static boolean playedWorld = false;
    public static Random random = new Random();
    public static List<SoundEvent> soundListMC = new ArrayList<SoundEvent>();
    public static List<SoundEvent> soundListWorld = new ArrayList<SoundEvent>();
    public static List<Float> pitchListMC = new ArrayList<Float>();
    public static List<Float> pitchListWorld = new ArrayList<Float>();

    public static void initLists() {
        Float pitch;
        SoundEvent soundEvent;
        String[] soundEntries;
        soundListMC.clear();
        soundListWorld.clear();
        pitchListMC.clear();
        pitchListWorld.clear();
        for (String sound : UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMC) {
            soundEntries = sound.split(";");
            soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(soundEntries[0]));
            if (soundEvent != null) {
                pitch = new Float(soundEntries[1]);
                soundListMC.add(soundEvent);
                pitchListMC.add(pitch);
                continue;
            }
            UniversalTweaks.LOGGER.warn("Unable to find sound: {}", (Object)new ResourceLocation(soundEntries[0]));
        }
        for (String sound : UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundWorld) {
            soundEntries = sound.split(";");
            soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(soundEntries[0]));
            if (soundEvent != null) {
                pitch = new Float(soundEntries[1]);
                soundListWorld.add(soundEvent);
                pitchListWorld.add(pitch);
                continue;
            }
            UniversalTweaks.LOGGER.warn("Unable to find sound: {}", (Object)new ResourceLocation(soundEntries[0]));
        }
        UniversalTweaks.LOGGER.info("Load Sound lists initialized");
    }

    public static void playRandomSoundMC() {
        if (soundListMC.isEmpty()) {
            return;
        }
        int randomIndex = random.nextInt(soundListMC.size());
        SoundEvent soundEvent = soundListMC.get(randomIndex);
        Float pitch = pitchListMC.get(randomIndex);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)soundEvent, (float)pitch.floatValue()));
    }

    public static void playRandomSoundWorld() {
        if (soundListMC.isEmpty()) {
            return;
        }
        int randomIndex = random.nextInt(soundListWorld.size());
        SoundEvent soundEvent = soundListWorld.get(randomIndex);
        Float pitch = pitchListWorld.get(randomIndex);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)soundEvent, (float)pitch.floatValue()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utMenuSound(GuiOpenEvent event) {
        if (!playedMenu && event.getGui() instanceof GuiMainMenu) {
            if (UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode == UTConfigTweaks.MiscCategory.LoadSoundsCategory.EnumSoundModes.MINECRAFT || UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode == UTConfigTweaks.MiscCategory.LoadSoundsCategory.EnumSoundModes.MINECRAFT_AND_WORLD) {
                UTLoadSound.playRandomSoundMC();
            }
            playedMenu = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utWorldSound(EntityJoinWorldEvent event) {
        if (!playedWorld && event.getEntity() instanceof EntityPlayerSP) {
            if (UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode == UTConfigTweaks.MiscCategory.LoadSoundsCategory.EnumSoundModes.WORLD || UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode == UTConfigTweaks.MiscCategory.LoadSoundsCategory.EnumSoundModes.MINECRAFT_AND_WORLD) {
                UTLoadSound.playRandomSoundWorld();
            }
            playedWorld = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utWorldSoundReset(PlayerEvent.PlayerLoggedOutEvent event) {
        playedWorld = false;
    }
}

