/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.items.useduration;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber(modid="universaltweaks")
public class UTCustomUseDuration {
    public static Map<String, Integer> itemUseDurationMap = new Object2IntOpenHashMap();
    public static Map<String, Integer> itemUseCooldownMap = new Object2IntOpenHashMap();
    public static int used = 0;

    public static void initItemUseMaps() {
        itemUseDurationMap.clear();
        itemUseCooldownMap.clear();
        try {
            for (String config : UTConfigTweaks.ITEMS.utCustomUseDurations) {
                String[] configParts = config.split(";");
                String[] itemParts = configParts[0].split(":");
                ResourceLocation resLoc = new ResourceLocation(itemParts[0], itemParts[1]);
                int cooldown = 0;
                if (configParts.length > 2) {
                    cooldown = Integer.parseInt(configParts[2]);
                }
                int meta = 0;
                if (itemParts.length > 2) {
                    meta = Integer.parseInt(itemParts[2]);
                }
                int duration = Integer.parseInt(configParts[1]);
                if (!ForgeRegistries.ITEMS.containsKey(resLoc)) continue;
                itemUseDurationMap.put(((Item)ForgeRegistries.ITEMS.getValue(resLoc)).toString() + meta, duration);
                itemUseCooldownMap.put(((Item)ForgeRegistries.ITEMS.getValue(resLoc)).toString() + meta, cooldown);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UniversalTweaks.LOGGER.info("Item use duration map initialized");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void utCustomUseDurationTick(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntityLiving().func_130014_f_().field_72995_K) {
            return;
        }
        ItemStack stack = event.getItem();
        int duration = UTCustomUseDuration.getCustomDuration(stack);
        if (duration < 0) {
            return;
        }
        if (++used >= duration) {
            used = 0;
            EntityLivingBase entity = event.getEntityLiving();
            entity.func_184597_cx();
            int cooldown = UTCustomUseDuration.getCustomCooldown(stack);
            if (cooldown > 0 && entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_184811_cZ().func_185145_a(stack.func_77973_b(), cooldown);
            }
            event.setCanceled(true);
        }
    }

    public static int getCustomDuration(ItemStack stack) {
        int meta = 0;
        try {
            if (stack.func_77981_g()) {
                meta = stack.func_77960_j();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String itemKey = stack.func_77973_b().toString() + meta;
        if (itemUseDurationMap.containsKey(itemKey)) {
            return itemUseDurationMap.get(itemKey);
        }
        return -1;
    }

    public static int getCustomCooldown(ItemStack stack) {
        int meta = 0;
        try {
            if (stack.func_77981_g()) {
                meta = stack.func_77960_j();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String itemKey = stack.func_77973_b().toString() + meta;
        if (itemUseCooldownMap.containsKey(itemKey)) {
            return itemUseCooldownMap.get(itemKey);
        }
        return -1;
    }
}

