/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.items.parry;

import java.util.ArrayList;
import java.util.List;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="universaltweaks")
public class UTParry {
    public static Enchantment enchantment;
    public static EnumEnchantmentType enchantmentTypeShield;
    public static List<EntityEntry> projectileList;

    public static void initProjectileList() {
        projectileList.clear();
        try {
            for (String entry : UTConfigTweaks.ITEMS.PARRY.utParryProjectileList) {
                ResourceLocation resLoc = new ResourceLocation(entry);
                if (!ForgeRegistries.ENTITIES.containsKey(resLoc)) continue;
                projectileList.add((EntityEntry)ForgeRegistries.ENTITIES.getValue(resLoc));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UniversalTweaks.LOGGER.info("Parry projectile list initialized");
    }

    @SubscribeEvent
    public static void utRegisterEnchantment(RegistryEvent.Register<Enchantment> event) {
        if (!UTConfigTweaks.ITEMS.PARRY.utParryToggle || !UTConfigTweaks.ITEMS.PARRY.utParryReboundToggle) {
            return;
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTParry ::: Register enchantment");
        }
        enchantmentTypeShield = EnumHelper.addEnchantmentType((String)"shield", input -> input instanceof ItemShield || input != null && input.isShield(new ItemStack(input, 1, 0), null));
        enchantment = ((Enchantment)new EnchantmentRebound(Enchantment.Rarity.COMMON).setRegistryName(new ResourceLocation("parry", "parry"))).func_77322_b("parry");
        event.getRegistry().register((IForgeRegistryEntry)enchantment);
    }

    @SubscribeEvent
    public static void utArrowParry(ProjectileImpactEvent.Arrow event) {
        boolean isBlacklist;
        if (!UTConfigTweaks.ITEMS.PARRY.utParryToggle) {
            return;
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTParry ::: Parry arrow");
        }
        final EntityArrow projectile = event.getArrow();
        EntityEntry projectileEntity = EntityRegistry.getEntry(projectile.getClass());
        boolean bl = isBlacklist = UTConfigTweaks.ITEMS.PARRY.utParryProjectileListMode == UTConfigTweaks.EnumLists.BLACKLIST;
        if (projectileList.contains(projectileEntity) == isBlacklist) {
            return;
        }
        if (!projectile.func_130014_f_().field_72995_K) {
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase) {
                EntityLivingBase entityBlocking = (EntityLivingBase)entity;
                if (UTConfigTweaks.ITEMS.PARRY.utParryReboundRequire && UTParry.getEnchantedLevel(entityBlocking.func_184607_cu()) == 0) {
                    return;
                }
                if (entityBlocking.func_184583_d(new DamageSource("parry_this"){

                    public Vec3d func_188404_v() {
                        return projectile.func_174791_d();
                    }
                }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= UTParry.applyTimerBonus(UTConfigTweaks.ITEMS.PARRY.utParryArrowTimeWindow, entityBlocking.func_184607_cu(), (float)UTConfigTweaks.ITEMS.PARRY.utParryReboundMultiplier)) {
                    Vec3d playerVec3 = entityBlocking.func_70040_Z();
                    projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                    projectile.field_70250_c = entityBlocking;
                    entityBlocking.field_70170_p.func_184133_a(null, entityBlocking.func_180425_c(), SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 1.0f, 0.8f + entityBlocking.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    if (UTConfigTweaks.ITEMS.PARRY.utParrySound) {
                        entityBlocking.field_70170_p.func_184133_a(null, entityBlocking.func_180425_c(), SoundEvents.field_187734_u, SoundCategory.PLAYERS, 0.5f, 2.0f);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void utFireballParry(ProjectileImpactEvent.Fireball event) {
        boolean isBlacklist;
        if (!UTConfigTweaks.ITEMS.PARRY.utParryToggle) {
            return;
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTParry ::: Parry fireball");
        }
        final EntityFireball projectile = event.getFireball();
        EntityEntry projectileEntity = EntityRegistry.getEntry(projectile.getClass());
        boolean bl = isBlacklist = UTConfigTweaks.ITEMS.PARRY.utParryProjectileListMode == UTConfigTweaks.EnumLists.BLACKLIST;
        if (projectileList.contains(projectileEntity) == isBlacklist) {
            return;
        }
        if (!projectile.func_130014_f_().field_72995_K) {
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase) {
                EntityLivingBase entityBlocking = (EntityLivingBase)entity;
                if (UTConfigTweaks.ITEMS.PARRY.utParryReboundRequire && UTParry.getEnchantedLevel(entityBlocking.func_184607_cu()) == 0) {
                    return;
                }
                if (entityBlocking.func_184583_d(new DamageSource("parry_this"){

                    public Vec3d func_188404_v() {
                        return projectile.func_174791_d();
                    }
                }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= UTParry.applyTimerBonus(UTConfigTweaks.ITEMS.PARRY.utParryFireballTimeWindow, entityBlocking.func_184607_cu(), (float)UTConfigTweaks.ITEMS.PARRY.utParryReboundMultiplier)) {
                    Vec3d playerVec3 = entityBlocking.func_70040_Z();
                    projectile.field_70159_w = playerVec3.field_72450_a;
                    projectile.field_70181_x = playerVec3.field_72448_b;
                    projectile.field_70179_y = playerVec3.field_72449_c;
                    projectile.field_70232_b = projectile.field_70159_w * 0.1;
                    projectile.field_70233_c = projectile.field_70181_x * 0.1;
                    projectile.field_70230_d = projectile.field_70179_y * 0.1;
                    projectile.field_70235_a = entityBlocking;
                    entityBlocking.field_70170_p.func_184133_a(null, entityBlocking.func_180425_c(), SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 1.0f, 0.8f + entityBlocking.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    if (UTConfigTweaks.ITEMS.PARRY.utParrySound) {
                        entityBlocking.field_70170_p.func_184133_a(null, entityBlocking.func_180425_c(), SoundEvents.field_187734_u, SoundCategory.PLAYERS, 0.5f, 2.0f);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void utThrowableParry(ProjectileImpactEvent.Throwable event) {
        boolean isBlacklist;
        if (!UTConfigTweaks.ITEMS.PARRY.utParryToggle) {
            return;
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTParry ::: Parry throwable");
        }
        final EntityThrowable projectile = event.getThrowable();
        EntityEntry projectileEntity = EntityRegistry.getEntry(projectile.getClass());
        boolean bl = isBlacklist = UTConfigTweaks.ITEMS.PARRY.utParryProjectileListMode == UTConfigTweaks.EnumLists.BLACKLIST;
        if (projectileList.contains(projectileEntity) == isBlacklist) {
            return;
        }
        if (!projectile.func_130014_f_().field_72995_K) {
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase) {
                EntityLivingBase entityBlocking = (EntityLivingBase)entity;
                if (UTConfigTweaks.ITEMS.PARRY.utParryReboundRequire && UTParry.getEnchantedLevel(entityBlocking.func_184607_cu()) == 0) {
                    return;
                }
                if (entityBlocking.func_184583_d(new DamageSource("parry_this"){

                    public Vec3d func_188404_v() {
                        return projectile.func_174791_d();
                    }
                }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= UTParry.applyTimerBonus(UTConfigTweaks.ITEMS.PARRY.utParryThrowableTimeWindow, entityBlocking.func_184607_cu(), (float)UTConfigTweaks.ITEMS.PARRY.utParryReboundMultiplier)) {
                    Vec3d playerVec3 = entityBlocking.func_70040_Z();
                    projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                    projectile.field_70192_c = entityBlocking;
                    entityBlocking.field_70170_p.func_184133_a(null, entityBlocking.func_180425_c(), SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 1.0f, 0.8f + entityBlocking.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    if (UTConfigTweaks.ITEMS.PARRY.utParrySound) {
                        entityBlocking.field_70170_p.func_184133_a(null, entityBlocking.func_180425_c(), SoundEvents.field_187734_u, SoundCategory.PLAYERS, 0.5f, 2.0f);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    public static int applyTimerBonus(int base, ItemStack stack, float multiplier) {
        return (int)((float)base + (float)(base * UTParry.getEnchantedLevel(stack)) * multiplier);
    }

    public static int getEnchantedLevel(ItemStack stack) {
        int level = 0;
        for (NBTBase nbt : stack.func_77986_q()) {
            NBTTagCompound compound;
            if (!(nbt instanceof NBTTagCompound) || Enchantment.func_185262_c((int)(compound = (NBTTagCompound)nbt).func_74765_d("id")) != enchantment) continue;
            level += compound.func_74765_d("lvl");
        }
        return level;
    }

    static {
        projectileList = new ArrayList<EntityEntry>();
    }

    public static class EnchantmentRebound
    extends Enchantment {
        EnchantmentRebound(Enchantment.Rarity rarityIn) {
            super(rarityIn, enchantmentTypeShield, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        }

        public int func_77325_b() {
            return UTConfigTweaks.ITEMS.PARRY.utParryReboundMaxLevel;
        }

        public boolean func_185261_e() {
            return UTConfigTweaks.ITEMS.PARRY.utParryReboundTreasure;
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemShield || stack.func_77973_b().isShield(stack, null);
        }
    }
}

