/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.abyssalcraft.worlddata;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mod.acgaming.universaltweaks.mods.abyssalcraft.worlddata.IUTWorldDataCapability;
import mod.acgaming.universaltweaks.mods.abyssalcraft.worlddata.UTWorldDataCapabilityProvider;
import mod.acgaming.universaltweaks.mods.abyssalcraft.worlddata.UTWorldDataCapabilityStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class UTWorldDataCapability
implements IUTWorldDataCapability {
    private final Map<Chunk, Map<BlockPos, TileEntity>> configuredTileEntities = new Object2ObjectOpenHashMap();

    public static void register() {
        CapabilityManager.INSTANCE.register(IUTWorldDataCapability.class, UTWorldDataCapabilityStorage.INSTANCE, UTWorldDataCapability::new);
    }

    public static IUTWorldDataCapability getCap(World world) {
        return (IUTWorldDataCapability)world.getCapability(UTWorldDataCapabilityProvider.WORLD_DATA_CAP, null);
    }

    @Override
    public boolean isEmpty() {
        return this.configuredTileEntities.isEmpty();
    }

    @Override
    public boolean contains(Chunk chunk) {
        return this.configuredTileEntities.containsKey(chunk);
    }

    @Override
    public Map<BlockPos, TileEntity> getOrCreateMap(Chunk chunk) {
        Object2ObjectOpenHashMap positions = this.configuredTileEntities.get(chunk);
        if (positions == null) {
            positions = new Object2ObjectOpenHashMap();
            this.configuredTileEntities.put(chunk, (Map<BlockPos, TileEntity>)positions);
        }
        return positions;
    }

    @Override
    public Map<BlockPos, TileEntity> getChunkMap(Chunk chunk) {
        return this.configuredTileEntities.get(chunk);
    }

    @Override
    public Map<BlockPos, TileEntity> getFlattenedView() {
        Object2ObjectOpenHashMap flattenedMap = new Object2ObjectOpenHashMap();
        for (Map<BlockPos, TileEntity> map : this.configuredTileEntities.values()) {
            flattenedMap.putAll(map);
        }
        return flattenedMap;
    }

    @Override
    public void addConfigured(Chunk chunk, BlockPos pos, TileEntity te) {
        this.getOrCreateMap(chunk).putIfAbsent(pos, te);
    }

    @Override
    public void updateConfigured(Chunk chunk, BlockPos pos, TileEntity te) {
        this.getOrCreateMap(chunk).put(pos, te);
    }

    @Override
    public void removeConfigured(Chunk chunk, BlockPos pos) {
        Map<BlockPos, TileEntity> map = this.getOrCreateMap(chunk);
        map.remove(pos);
        if (map.isEmpty()) {
            this.removeChunk(chunk);
        }
    }

    @Override
    public void removeChunk(Chunk chunk) {
        this.configuredTileEntities.remove(chunk);
    }
}

