/*
 * Decompiled with CFR 0.152.
 */
package io.github.twilightflower.paraglider.compat;

import com.elenai.elenaidodge2.api.FeathersHelper;
import io.github.twilightflower.paraglider.Config;
import io.github.twilightflower.paraglider.ParagliderEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.Loader;

public class ElenaiDodgeCompat {
    public static final ElenaiDodgeCompat INSTANCE = Loader.isModLoaded((String)"elenaidodge2") && Config.elenaiDodgeCompat ? new Impl() : new ElenaiDodgeCompat();

    private ElenaiDodgeCompat() {
    }

    public boolean tick(ParagliderEntity glider, Entity rider) {
        return true;
    }

    public boolean canGlide(EntityPlayer player) {
        return true;
    }

    public static class Impl
    extends ElenaiDodgeCompat {
        @Override
        public boolean canGlide(EntityPlayer player) {
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMp = (EntityPlayerMP)player;
                int weight = FeathersHelper.getWeight((EntityPlayerMP)playerMp);
                int feathers = FeathersHelper.getFeatherLevel((EntityPlayerMP)playerMp);
                return feathers > weight;
            }
            return true;
        }

        @Override
        public boolean tick(ParagliderEntity glider, Entity rider) {
            if (rider instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)rider;
                int weight = FeathersHelper.getWeight((EntityPlayerMP)player);
                int feathers = FeathersHelper.getFeatherLevel((EntityPlayerMP)player);
                glider.partialFeathers += Config.featherRate;
                if (glider.partialFeathers >= 1.0f) {
                    int fullFeathers = (int)glider.partialFeathers;
                    glider.partialFeathers -= (float)fullFeathers;
                    feathers -= fullFeathers;
                    FeathersHelper.decreaseFeathers((EntityPlayerMP)player, (int)fullFeathers);
                }
                return feathers > weight;
            }
            return true;
        }
    }
}

