/*
 * Decompiled with CFR 0.152.
 */
package io.github.twilightflower.paraglider.client;

import io.github.twilightflower.paraglider.ParagliderEntity;
import io.github.twilightflower.paraglider.Util;
import io.github.twilightflower.paraglider.client.ArmRendererHack;
import io.github.twilightflower.paraglider.client.ClientAccessHelper;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientEvents {
    private static final ModelBiped.ArmPose GLIDING = (ModelBiped.ArmPose)EnumHelper.addEnum(ModelBiped.ArmPose.class, (String)"GLIDING", (Class[])new Class[0], (Object[])new Object[0]);
    private static final Map<RenderPlayer, LayerBipedArmor> ARMOR_MAP = new WeakHashMap<RenderPlayer, LayerBipedArmor>();
    private static final Map<ModelBase, Void> ARMOR_MODEL_SET = new WeakHashMap<ModelBase, Void>();
    private static final EntityEquipmentSlot[] ARMOR_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.HEAD};
    private static ItemStack heldMainHand;
    private static ItemStack heldOffHand;
    private static boolean cancelSound;

    @SubscribeEvent
    public void cancelHandRender(RenderHandEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() instanceof ParagliderEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderHud(RenderGameOverlayEvent.Pre event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && player.func_184187_bx() instanceof ParagliderEntity) {
            GuiIngameForge.renderFood = true;
        }
    }

    @SubscribeEvent
    public void preRenderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184187_bx() instanceof ParagliderEntity) {
            ParagliderEntity paraglider = (ParagliderEntity)player.func_184187_bx();
            cancelSound = true;
            heldMainHand = player.func_184614_ca();
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            heldOffHand = player.func_184592_cb();
            player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            cancelSound = false;
            player.field_70761_aq = paraglider.field_70177_z;
            player.field_70760_ar = paraglider.field_70126_B;
            float roll = Util.lerp(paraglider.prevRotationRoll, paraglider.rotationRoll, event.getPartialRenderTick());
            float yaw = Util.lerp(paraglider.field_70126_B, paraglider.field_70177_z, event.getPartialRenderTick());
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)player.field_70131_O), (double)event.getZ());
            GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)roll, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY() - (double)player.field_70131_O), (double)(-event.getZ()));
        }
    }

    @SubscribeEvent
    public void preRenderLiving(RenderLivingEvent.Pre<?> event) {
        if (event.getRenderer() instanceof RenderPlayer) {
            LayerBipedArmor armorLayer;
            RenderPlayer render = (RenderPlayer)event.getRenderer();
            ModelPlayer model = render.func_177087_b();
            AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
            if (!ARMOR_MAP.containsKey(render)) {
                this.hackArms((ModelBiped)model);
                model.field_178734_a = new ArmRendererHack((ModelBase)model, model.field_178734_a, () -> model.field_187075_l == GLIDING, false);
                model.field_178732_b = new ArmRendererHack((ModelBase)model, model.field_178732_b, () -> model.field_187076_m == GLIDING, true);
                for (LayerRenderer<?> layer : ClientAccessHelper.getLayers(render)) {
                    if (!(layer instanceof LayerBipedArmor)) continue;
                    ARMOR_MAP.put(render, (LayerBipedArmor)layer);
                    break;
                }
            }
            if ((armorLayer = ARMOR_MAP.get(render)) != null) {
                for (EntityEquipmentSlot slot : ARMOR_SLOTS) {
                    ModelBase armorModel = ClientAccessHelper.getArmorModelHook(armorLayer, (EntityLivingBase)player, player.func_184582_a(slot), slot, armorLayer.func_188360_a(slot));
                    if (ARMOR_MODEL_SET.containsKey(armorModel)) continue;
                    ARMOR_MODEL_SET.put(armorModel, null);
                    if (!(armorModel instanceof ModelBiped)) continue;
                    this.hackArms((ModelBiped)armorModel);
                }
            }
            if (event.getEntity().func_184187_bx() instanceof ParagliderEntity) {
                model.field_187075_l = GLIDING;
                model.field_187076_m = GLIDING;
            }
        }
    }

    private void hackArms(ModelBiped model) {
        model.field_178724_i = new ArmRendererHack((ModelBase)model, model.field_178724_i, () -> model.field_187075_l == GLIDING, false);
        model.field_178723_h = new ArmRendererHack((ModelBase)model, model.field_178723_h, () -> model.field_187076_m == GLIDING, true);
    }

    @SubscribeEvent
    public void postRenderPlayer(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184187_bx() instanceof ParagliderEntity) {
            GlStateManager.func_179121_F();
            cancelSound = true;
            player.func_184611_a(EnumHand.MAIN_HAND, heldMainHand);
            heldMainHand = ItemStack.field_190927_a;
            player.func_184611_a(EnumHand.OFF_HAND, heldOffHand);
            heldOffHand = ItemStack.field_190927_a;
            cancelSound = false;
        }
    }

    @SubscribeEvent
    public void noEquipSounds(PlaySoundAtEntityEvent event) {
        if (cancelSound) {
            event.setCanceled(true);
        }
    }

    static {
        cancelSound = false;
    }
}

