/*
 * Decompiled with CFR 0.152.
 */
package io.github.twilightflower.paraglider;

import io.github.twilightflower.paraglider.AccessHelper;
import io.github.twilightflower.paraglider.Config;
import io.github.twilightflower.paraglider.SimpleParagliderMod;
import io.github.twilightflower.paraglider.Util;
import io.github.twilightflower.paraglider.client.PleaseDontCrashClassloading;
import io.github.twilightflower.paraglider.compat.ElenaiDodgeCompat;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ParagliderEntity
extends Entity {
    private static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    private float yawMotion = 0.0f;
    private int durabilityTimer = Config.durabilityRate;
    public boolean shouldDismount = false;
    public EnumHand usedHand = EnumHand.MAIN_HAND;
    public float partialFeathers = 0.0f;
    public float prevRotationRoll;
    public float rotationRoll;
    private static final EnumHand[] HANDS = EnumHand.values();

    public ParagliderEntity(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.field_70143_R = 0.0f;
        Entity rider = this.func_184179_bs();
        this.prevRotationRoll = this.rotationRoll;
        if (!(rider == null || rider.field_70128_L || rider.field_70122_E || this.field_70122_E || this.shouldDismount || !this.isHoldingGlider(rider) || !ElenaiDodgeCompat.INSTANCE.tick(this, rider) || this.field_70171_ac)) {
            if (this.field_70181_x > 0.0) {
                this.field_70181_x = Util.towards(this.field_70181_x, (double)Config.terminalVelocity, (double)Config.upGravity);
                this.field_70159_w *= 0.98;
                this.field_70179_y *= 0.98;
            } else {
                float yawDiff = Util.angleDiff(rider.field_70177_z, this.field_70177_z);
                float absDiff = Math.abs(yawDiff);
                float diffSign = Math.signum(yawDiff);
                float targetYawSpeed = diffSign * Config.maxYawV;
                if (absDiff < Config.yawSnapDist && Math.abs(this.yawMotion) < Config.yawSnapSpeed) {
                    this.yawMotion = 0.0f;
                    this.field_70177_z = rider.field_70177_z;
                } else {
                    this.yawMotion = diffSign == Math.signum(this.yawMotion) ? Util.towards(this.yawMotion, targetYawSpeed, Config.yawAccel) : Util.towards(this.yawMotion, targetYawSpeed, Config.yawDecel);
                }
                this.field_70177_z += this.yawMotion;
                this.rotationRoll = Util.towards(this.rotationRoll, this.yawMotion * Config.tiltFac, Config.tiltSpeed);
                float fallSpeedFactor = Math.min((float)this.field_70181_x / Config.terminalVelocity, 1.0f);
                float accel = fallSpeedFactor * Config.horizontalAccel;
                float radYaw = this.field_70177_z * ((float)Math.PI / 180);
                float accelX = -MathHelper.func_76126_a((float)radYaw) * accel;
                float accelZ = MathHelper.func_76134_b((float)radYaw) * accel;
                this.field_70159_w += (double)accelX;
                this.field_70179_y += (double)accelZ;
                this.field_70159_w *= (double)Config.airResistance;
                this.field_70179_y *= (double)Config.airResistance;
                if (this.field_70181_x > (double)Config.terminalVelocity) {
                    this.field_70181_x = Util.towards(this.field_70181_x, (double)Config.terminalVelocity, (double)Config.gravity);
                } else if (this.field_70181_x < (double)Config.terminalVelocity) {
                    this.field_70181_x = Util.towards(this.field_70181_x, (double)Config.terminalVelocity, (double)Config.fallDecel);
                }
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.durabilityTimer-- <= 0) {
                this.durabilityTimer = Config.durabilityRate;
                if (rider instanceof EntityLivingBase && !this.field_70170_p.field_72995_K) {
                    EntityLivingBase living = (EntityLivingBase)rider;
                    living.func_184586_b(this.usedHand).func_77972_a(1, living);
                }
            }
        } else if (this.field_70181_x > 0.0) {
            this.field_70181_x -= (double)Config.upGravity;
        } else if (!this.field_70170_p.field_72995_K) {
            this.manualDismount();
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    public void onAddedToWorld() {
        if (SimpleParagliderMod.isClient && this.field_70170_p.field_72995_K) {
            PleaseDontCrashClassloading.startGliderSound(this);
        }
    }

    private boolean isHoldingGlider(Entity passenger) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (passenger instanceof EntityLivingBase) {
            EntityLivingBase e = (EntityLivingBase)passenger;
            return e.func_184586_b(this.usedHand).func_77973_b() == SimpleParagliderMod.PARAGLIDER;
        }
        return true;
    }

    public void func_70106_y() {
        this.manualDismount();
        this.func_184185_a(SoundEvents.field_191258_p, 1.0f, 1.0f);
        super.func_70106_y();
    }

    public void manualDismount() {
        Entity passenger = this.func_184179_bs();
        if (passenger != null) {
            AccessHelper.setRidingEntity(passenger, null);
            this.func_184225_p(passenger);
            passenger.func_70095_a(false);
            passenger.field_70159_w = this.field_70159_w;
            passenger.field_70181_x = this.field_70181_x;
            passenger.field_70179_y = this.field_70179_y;
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        this.field_70159_w = passenger.field_70159_w;
        this.field_70181_x = passenger.field_70181_x;
        this.field_70179_y = passenger.field_70179_y;
    }

    public void func_184232_k(Entity passenger) {
        passenger.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        passenger.field_70143_R = 0.0f;
        if (passenger instanceof EntityPlayer) {
            ((EntityPlayer)passenger).func_184811_cZ().func_185145_a(SimpleParagliderMod.PARAGLIDER, Config.cooldownTime);
        }
    }

    public Entity func_184179_bs() {
        List passengers = this.func_184188_bt();
        return passengers.isEmpty() ? null : (Entity)passengers.get(0);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected void func_70088_a() {
    }

    private EnumHand getHand(int hand) {
        if (hand < HANDS.length) {
            return HANDS[hand];
        }
        return EnumHand.MAIN_HAND;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.yawMotion = compound.func_74760_g("yaw_motion");
        this.partialFeathers = compound.func_74760_g("partial_feathers");
        this.usedHand = this.getHand(compound.func_74762_e("hand"));
        if (compound.func_74764_b("durability_timer")) {
            this.durabilityTimer = compound.func_74762_e("durability_timer");
        }
        if (!this.field_70170_p.field_72995_K && this.func_184179_bs() == null) {
            this.func_70106_y();
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("yaw_motion", this.yawMotion);
        compound.func_74776_a("partial_feathers", this.partialFeathers);
        compound.func_74768_a("durability_timer", this.durabilityTimer);
        compound.func_74768_a("hand", this.usedHand.ordinal());
    }
}

