/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.EntityData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.CuredZombieVillagerTrigger;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/cured_zombie_villager", classExplaination="These are the functions which can be called on a minecraft:cured_zombie_villager criteria trigger.")
public class CuredZombieVillagerTriggerData
extends CriterionTriggerData {
    private final EntityData zombie = new EntityData();
    private final EntityData villager = new EntityData();

    public CuredZombieVillagerTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        return new Criterion((ICriterionInstance)new CuredZombieVillagerTrigger.Instance(this.zombie.buildPredicate(), this.villager.buildPredicate()));
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object for the zombie so functions can be called on it.")
    public EntityData getZombieData() {
        return this.zombie;
    }

    @ScriptMethodDocumentation(args="String", usage="entity type", notes="Sets the zombie entity type.")
    public void setZombieType(String type) {
        this.zombie.setType(type);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object for the villager so functions can be called on it.")
    public EntityData getVillagerData() {
        return this.villager;
    }

    @ScriptMethodDocumentation(args="String", usage="entity type", notes="Sets the villager entity type.")
    public void setVillagerType(String type) {
        this.villager.setType(type);
    }
}

