/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.client.renderer.blockentity.state.CraftingTableRenderState;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableAnimationController;
import fuzs.visualworkbench.world.level.block.entity.WorkbenchVisualsProvider;
import java.util.ArrayList;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CraftingTableBlockEntityRenderer<T extends BlockEntity & WorkbenchVisualsProvider>
implements BlockEntityRenderer<T, CraftingTableRenderState> {
    private final ItemModelResolver itemModelResolver;

    public CraftingTableBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public CraftingTableRenderState createRenderState() {
        return new CraftingTableRenderState();
    }

    public void extractRenderState(T blockEntity, CraftingTableRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.result.clear();
        int position = (int)blockEntity.getBlockPos().asLong();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).resultRendering) {
            this.itemModelResolver.updateForTopItem(renderState.result, ((WorkbenchVisualsProvider)blockEntity).getCraftingResult(), ItemDisplayContext.GROUND, blockEntity.getLevel(), null, position);
        }
        renderState.items = new ArrayList<ItemStackRenderState>();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).ingredientRendering != ClientConfig.IngredientRendering.NONE) {
            for (int i = 0; i < ((Container)blockEntity).getContainerSize(); ++i) {
                ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
                this.itemModelResolver.updateForTopItem(itemStackRenderState, ((Container)blockEntity).getItem(i), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, position + i);
                renderState.items.add(itemStackRenderState);
            }
        }
        CraftingTableAnimationController animationController = ((WorkbenchVisualsProvider)blockEntity).getAnimationController();
        renderState.time = (float)animationController.getTime() + partialTick;
        renderState.angle = Mth.lerp((float)partialTick, (float)animationController.getCurrentAngle(), (float)animationController.getNextAngle());
        renderState.itemLightCoords = blockEntity.getLevel() != null ? LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().above()) : 0xF000F0;
    }

    public void submit(CraftingTableRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        block4: for (int i = 0; i < renderState.items.size(); ++i) {
            switch (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).ingredientRendering) {
                case FLAT: {
                    this.submitFlatItemList(renderState, poseStack, nodeCollector, i);
                    continue block4;
                }
                case FLOATING: {
                    this.submitFloatingItemList(renderState, poseStack, nodeCollector, i);
                }
            }
        }
        this.submitFloatingItemStack(renderState, poseStack, nodeCollector);
    }

    private void submitFlatItemList(CraftingTableRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, int index) {
        ItemStackRenderState itemStackRenderState = renderState.items.get(index);
        if (!itemStackRenderState.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.angle));
            poseStack.translate((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, CraftingTableBlockEntityRenderer.isGui3d(itemStackRenderState) ? 1.0625 : 1.005, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            float scale = CraftingTableBlockEntityRenderer.isGui3d(itemStackRenderState) ? 0.25f : 0.175f;
            poseStack.scale(scale, scale, scale);
            itemStackRenderState.submit(poseStack, nodeCollector, renderState.itemLightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    private void submitFloatingItemList(CraftingTableRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, int index) {
        ItemStackRenderState itemStackRenderState = renderState.items.get(index);
        if (!itemStackRenderState.isEmpty()) {
            poseStack.pushPose();
            float shift = (float)Math.abs(((double)renderState.time * 50.0 + (double)((long)index * 1000L)) % 5000.0 - 2500.0) / 200000.0f;
            poseStack.translate(0.5, (double)shift, 0.5);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.angle));
            poseStack.translate((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, 1.09375, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
            float scale = CraftingTableBlockEntityRenderer.isGui3d(itemStackRenderState) ? 0.24f : 0.18f;
            poseStack.scale(scale, scale, scale);
            itemStackRenderState.submit(poseStack, nodeCollector, renderState.itemLightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    private void submitFloatingItemStack(CraftingTableRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector) {
        ItemStackRenderState itemStackRenderState = renderState.result;
        if (!itemStackRenderState.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.15f, 0.5f);
            float hoverOffset = Mth.sin((float)(renderState.time / 10.0f)) * 0.04f + 0.1f;
            AABB aABB = itemStackRenderState.getModelBoundingBox();
            float modelYScale = -((float)aABB.minY) + 0.0625f;
            poseStack.translate(0.0, (double)(hoverOffset + modelYScale), 0.0);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotation(renderState.time / 20.0f));
            if (!CraftingTableBlockEntityRenderer.isGui3d(itemStackRenderState)) {
                poseStack.scale(0.75f, 0.75f, 0.75f);
            }
            itemStackRenderState.submit(poseStack, nodeCollector, renderState.itemLightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    private static boolean isGui3d(ItemStackRenderState renderState) {
        return renderState.getModelBoundingBox().getZsize() > 0.0625;
    }
}

