/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.TraceableException;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeLanguages;
import snownee.jade.util.KeyedResourceManagerReloadListener;
import snownee.jade.util.WordCutter;

public class ModIdentification
implements KeyedResourceManagerReloadListener {
    public static final ResourceLocation ID = JadeIds.JADE("mod_id");
    public static final ModIdentification INSTANCE = new ModIdentification();
    public static int NAME_MAX_WIDTH = 160;
    private static final Map<String, Optional<String>> NAMES = Maps.newConcurrentMap();
    private static final Map<String, Optional<String>> CUT_NAMES = Maps.newConcurrentMap();
    @Nullable
    private static WordCutter wordCutter;
    public static final String JADE_STACK = "$jade:stack";
    public static final MapCodec<ResourceLocation> JADE_STACK_ID_CODEC;
    public static final String POLYMER_STACK = "$polymer:stack";
    public static final MapCodec<ResourceLocation> POLYMER_STACK_ID_CODEC;

    public static WordCutter wordCutter() {
        WordCutter cutter = wordCutter;
        if (cutter == null) {
            JadeLanguages languages = JadeLanguages.INSTANCE;
            BreakIterator iterator = BreakIterator.getWordInstance(languages.getLocale());
            wordCutter = cutter = new WordCutter(iterator, languages);
        }
        return cutter;
    }

    public static void invalidateCache() {
        NAMES.clear();
        CUT_NAMES.clear();
        wordCutter = null;
    }

    public static String cutName(String fullName, int maxWidth) {
        WordCutter.Token last;
        int start;
        int tokens;
        fullName = fullName.trim();
        if (maxWidth <= 0) {
            return fullName;
        }
        if (DisplayHelper.font().width(fullName) <= maxWidth) {
            return fullName;
        }
        WordCutter cutter = ModIdentification.wordCutter();
        cutter.setText(fullName, maxWidth);
        do {
            tokens = cutter.tokenCount();
            cutter.removeBracketed();
            cutter.trim();
        } while (tokens != cutter.tokenCount() && cutter.tooLong());
        if (cutter.hasColon() && cutter.tooLong() && (start = cutter.findFirst((Predicate<WordCutter.Token>)((Predicate)token -> token.type() == WordCutter.TokenType.COLON))) != -1) {
            boolean remove;
            String s = cutter.concat(start + 1, cutter.tokenCount()).trim().toLowerCase(Locale.ENGLISH);
            boolean bl = remove = s.endsWith("edition") || s.endsWith("version");
            if (!remove && !s.contains(" ")) {
                boolean bl2 = remove = s.equals("legacy") || s.startsWith("re");
            }
            if (remove) {
                cutter.removeRange(start, cutter.tokenCount());
                cutter.trim();
            }
        }
        if (cutter.tooLong() && (last = cutter.tokens().getLast()).type() == WordCutter.TokenType.WORD && last.str().toLowerCase(Locale.ENGLISH).equals("mod")) {
            cutter.removeRange(cutter.tokenCount() - 1, cutter.tokenCount());
            cutter.trim();
        }
        cutter.cutToMaxWidth(true);
        return cutter.toString();
    }

    public static Optional<String> getModName(String namespace) {
        return ModIdentification.getModName(namespace, NAME_MAX_WIDTH);
    }

    public static Optional<String> getModName(String namespace, int maxWidth) {
        if (maxWidth != NAME_MAX_WIDTH) {
            return ModIdentification.getModNameInternal(namespace, maxWidth);
        }
        return CUT_NAMES.computeIfAbsent(namespace, $ -> ModIdentification.getModNameInternal($, NAME_MAX_WIDTH));
    }

    public static Optional<String> getModNameInternal(String namespace, int maxWidth) {
        String fullName = ModIdentification.getModFullName(namespace).orElse(null);
        if (fullName == null) {
            return Optional.empty();
        }
        return Optional.of(ModIdentification.cutName(fullName, maxWidth));
    }

    public static Optional<String> getModFullName(String namespace) {
        return NAMES.computeIfAbsent(namespace, $ -> {
            String key = "jade.modName." + $;
            if (I18n.exists((String)key)) {
                return Optional.of(I18n.get((String)key, (Object[])new Object[0]));
            }
            key = "itemGroup." + $;
            if (I18n.exists((String)key)) {
                return Optional.of(I18n.get((String)key, (Object[])new Object[0]));
            }
            return ClientProxy.getModName($).map(ChatFormatting::stripFormatting);
        });
    }

    public static String getModName(ResourceLocation id) {
        return ModIdentification.getModName(id.getNamespace()).orElse(id.getNamespace());
    }

    public static String getModName(Block block) {
        ResourceLocation id;
        try {
            id = CommonProxy.getId(block);
        }
        catch (Throwable e) {
            throw TraceableException.create(e, BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace());
        }
        return ModIdentification.getModName(id);
    }

    public static Optional<ResourceLocation> getSpecialId(ItemStack stack) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!CustomData.EMPTY.equals((Object)data)) {
            if (data.tag.contains(JADE_STACK)) {
                return data.tag.read(JADE_STACK_ID_CODEC);
            }
            if (data.tag.contains(POLYMER_STACK)) {
                return data.tag.read(POLYMER_STACK_ID_CODEC);
            }
        }
        return Optional.empty();
    }

    public static String getModId(ItemStack stack) {
        Optional<ResourceLocation> specialId = ModIdentification.getSpecialId(stack);
        if (specialId.isPresent()) {
            return specialId.orElseThrow().getNamespace();
        }
        return CommonProxy.getModIdFromItem(stack);
    }

    public static String getModName(ItemStack stack) {
        String id;
        try {
            for (JadeItemModNameCallback callback : WailaClientRegistration.instance().itemModNameCallback.callbacks()) {
                String s = callback.gatherItemModName(stack);
                if (Strings.isNullOrEmpty((String)s)) continue;
                return s;
            }
            id = ModIdentification.getModId(stack);
        }
        catch (Throwable e) {
            throw TraceableException.create(e, BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace());
        }
        return ModIdentification.getModName(id).orElse(id);
    }

    public static String getModName(Entity entity) {
        ResourceLocation id;
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            return ModIdentification.getModName(((ResourceKey)painting.getVariant().unwrapKey().orElseThrow()).location());
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return ModIdentification.getModName(itemEntity.getItem());
        }
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
            return ModIdentification.getModName(fallingBlock.getBlockState().getBlock());
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            return ModIdentification.getModName(((ResourceKey)villager.getVillagerData().profession().unwrapKey().orElseThrow()).location());
        }
        try {
            id = CommonProxy.getId(entity.getType());
        }
        catch (Throwable e) {
            throw TraceableException.create(e, BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).getNamespace());
        }
        return ModIdentification.getModName(id);
    }

    public void onResourceManagerReload(ResourceManager manager) {
        ModIdentification.invalidateCache();
    }

    @Override
    public ResourceLocation getUid() {
        return ID;
    }

    static {
        JADE_STACK_ID_CODEC = ResourceLocation.CODEC.fieldOf("id").fieldOf(JADE_STACK);
        POLYMER_STACK_ID_CODEC = ResourceLocation.CODEC.fieldOf("id").fieldOf(POLYMER_STACK);
    }
}

