/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.math.LongMath;
import java.text.NumberFormat;
import java.util.function.Supplier;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import snownee.jade.JadeClient;
import snownee.jade.api.ui.NarratableComponent;

public class FluidTextHelper {
    private static final char[] SUPERSCRIPT = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
    private static final char FRACTION_BAR = '\u2044';
    private static final char[] SUBSCRIPT = new char[]{'\u2080', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};

    public static String getUnicodeFraction(long numerator, long denominator, boolean simplify) {
        if (numerator < 0L || denominator < 0L) {
            throw new IllegalArgumentException("Numerator and denominator must be non negative.");
        }
        if (simplify && denominator != 0L) {
            long g = LongMath.gcd((long)numerator, (long)denominator);
            numerator /= g;
            denominator /= g;
        }
        StringBuilder numString = new StringBuilder();
        while (numerator > 0L) {
            numString.append(SUPERSCRIPT[(int)(numerator % 10L)]);
            numerator /= 10L;
        }
        StringBuilder denomString = new StringBuilder();
        while (denominator > 0L) {
            denomString.append(SUBSCRIPT[(int)(denominator % 10L)]);
            denominator /= 10L;
        }
        return numString.reverse().toString() + "\u2044" + String.valueOf(denomString.reverse());
    }

    private static String getFractionNarration(long numerator, long denominator, boolean simplify) {
        String key;
        if (numerator < 0L || denominator < 0L) {
            throw new IllegalArgumentException("Numerator and denominator must be non negative.");
        }
        if (simplify && denominator != 0L) {
            long g = LongMath.gcd((long)numerator, (long)denominator);
            numerator /= g;
            denominator /= g;
        }
        if (I18n.exists((String)(key = "narration.jade.%s/%s".formatted(numerator, denominator)))) {
            return I18n.get((String)key, (Object[])new Object[0]);
        }
        return JadeClient.formatString("narration.jade.N/N", numerator, denominator);
    }

    public static NarratableComponent getMillibuckets(long mb, boolean simplify) {
        return FluidTextHelper.makeString(mb, 0L, 0L, "mB");
    }

    private static NarratableComponent makeString(long integer, long numerator, long denominator, String unit) {
        return FluidTextHelper.makeString(integer == 0L && denominator != 0L ? "" : NumberFormat.getNumberInstance().format(integer), integer, numerator, denominator, unit);
    }

    private static NarratableComponent makeString(String integerString, long integer, long numerator, long denominator, String unit) {
        Supplier<String> narration;
        String string;
        if (denominator == 0L) {
            string = integerString + unit;
            narration = () -> integerString;
        } else if (integerString.isEmpty()) {
            string = FluidTextHelper.getUnicodeFraction(numerator, denominator, true) + unit;
            narration = () -> FluidTextHelper.getFractionNarration(numerator, denominator, true);
        } else {
            string = integerString + " " + FluidTextHelper.getUnicodeFraction(numerator, denominator, true) + unit;
            narration = () -> JadeClient.formatString("narration.jade.integer_and_fraction", integerString, FluidTextHelper.getFractionNarration(numerator, denominator, true));
        }
        return new NarratableComponent((Component)Component.literal((String)string), () -> {
            double number = integer;
            if (denominator != 0L) {
                number += (double)numerator / (double)denominator;
            }
            return JadeClient.formatString("narration.jade.unit." + unit, narration.get(), number);
        });
    }

    private FluidTextHelper() {
    }
}

