/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import snownee.jade.api.fluid.JadeFluidObject;

public class FluidInput {
    private final Holder<Fluid> fluid;
    private final DataComponentPatch components;

    public FluidInput(JadeFluidObject fluidObject) {
        this(fluidObject.getType(), fluidObject.getComponents());
    }

    public FluidInput(Holder<Fluid> holder, DataComponentPatch dataComponentPatch) {
        this.fluid = holder;
        this.components = dataComponentPatch;
    }

    public Fluid getFluid() {
        return (Fluid)this.fluid.value();
    }

    public String serialize(HolderLookup.Provider provider) {
        StringBuilder stringBuilder = new StringBuilder(this.getFluidName());
        String string = this.serializeComponents(provider);
        if (!string.isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(string);
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private String serializeComponents(HolderLookup.Provider provider) {
        RegistryOps dynamicOps = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return this.components.entrySet().stream().flatMap(arg_0 -> FluidInput.lambda$serializeComponents$1((DynamicOps)dynamicOps, arg_0)).collect(Collectors.joining(String.valueOf(',')));
    }

    private String getFluidName() {
        return this.fluid.unwrapKey().map(ResourceKey::location).orElseGet(() -> ResourceLocation.parse((String)("unknown[" + String.valueOf(this.fluid) + "]"))).toString();
    }

    private static /* synthetic */ Stream lambda$serializeComponents$1(DynamicOps dynamicOps, Map.Entry entry) {
        DataComponentType dataComponentType = (DataComponentType)entry.getKey();
        ResourceLocation resourceLocation = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)dataComponentType);
        if (resourceLocation == null) {
            return Stream.empty();
        }
        Optional optional = (Optional)entry.getValue();
        if (optional.isPresent()) {
            TypedDataComponent typedDataComponent = TypedDataComponent.createUnchecked((DataComponentType)dataComponentType, optional.get());
            return typedDataComponent.encodeValue(dynamicOps).result().stream().map(tag -> {
                String var10000 = resourceLocation.toString();
                return var10000 + "=" + String.valueOf(tag);
            });
        }
        return Stream.of("!" + String.valueOf(resourceLocation));
    }
}

