/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.EmptyAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.api.callback.JadeBeforeTooltipCollectCallback;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.ui.BoxElementImpl;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.RayTracing;
import snownee.jade.track.ProgressTracker;
import snownee.jade.util.ClientProxy;

public class WailaTickHandler {
    public static final String REMOVE_ELEMENTS = "$jade:remove";
    public static final MapCodec<List<ResourceLocation>> REMOVE_ELEMENTS_CODEC = ResourceLocation.CODEC.listOf().fieldOf("$jade:remove");
    private String lastNarration = "";
    private long lastNarrationTime = 0L;
    public ProgressTracker progressTracker = new ProgressTracker();
    @Nullable
    public BoxElementImpl rootElement;
    @Nullable
    public State state;

    public void narrate(Element element, boolean dedupe) {
        if (System.currentTimeMillis() - this.lastNarrationTime < 500L) {
            return;
        }
        Component component = element.cachedNarration();
        if (component == null) {
            return;
        }
        this.narrate(StringUtil.stripColor((String)component.getString()), dedupe);
        this.lastNarrationTime = System.currentTimeMillis();
    }

    public void narrate(String message, boolean dedupe) {
        if (message.isEmpty()) {
            return;
        }
        if (dedupe && message.equals(this.lastNarration)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            GameNarrator narrator = Minecraft.getInstance().getNarrator();
            narrator.logNarratedMessage(message);
            if (IWailaConfig.get().general().isDebug()) {
                Jade.LOGGER.info("Narrating: {}", (Object)message);
            }
            if (narrator.isActive()) {
                narrator.clear();
                narrator.narrateMessage(message, true);
            }
        });
        this.lastNarration = message;
    }

    public void clearState() {
        this.lastNarration = "";
        this.state = null;
        this.rootElement = null;
        this.progressTracker.clear();
    }

    public void tickClient() {
        Accessor<BlockHitResult> accessor;
        BlockHitResult blockTarget;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            OverlayRenderer.clearLingerTooltip();
            this.clearState();
            return;
        }
        this.progressTracker.tick();
        IWailaConfig.General config = IWailaConfig.get().general();
        if (!config.shouldDisplayTooltip()) {
            this.clearState();
            return;
        }
        if (JadeUI.isPinned()) {
            return;
        }
        if (!ClientProxy.shouldShowWithGui(mc, mc.screen)) {
            return;
        }
        Entity entity = mc.getCameraEntity();
        if (entity == null) {
            this.clearState();
            return;
        }
        RayTracing.INSTANCE.fire();
        HitResult target = RayTracing.INSTANCE.getTarget();
        if (target == null) {
            this.clearState();
            return;
        }
        boolean useRayTraceCallback = true;
        if (target instanceof BlockHitResult && (blockTarget = (BlockHitResult)target).getType() != HitResult.Type.MISS) {
            BlockState state = level.getBlockState(blockTarget.getBlockPos());
            if (state.isAir()) {
                accessor = WailaTickHandler.createEmpty(target);
            } else {
                BlockEntity tileEntity = level.getBlockEntity(blockTarget.getBlockPos());
                accessor = WailaClientRegistration.instance().blockAccessor().blockState(state).blockEntity(tileEntity).hit(blockTarget).requireVerification().build();
            }
        } else if (target instanceof EntityHitResult) {
            EntityHitResult entityTarget = (EntityHitResult)target;
            accessor = WailaClientRegistration.instance().entityAccessor().hit(entityTarget).entity(entityTarget.getEntity()).requireVerification().build();
        } else if (mc.screen instanceof PreviewOptionsScreen) {
            useRayTraceCallback = false;
            accessor = WailaClientRegistration.instance().blockAccessor().blockState(Blocks.GRASS_BLOCK.defaultBlockState()).hit(new BlockHitResult(entity.position(), Direction.UP, entity.blockPosition(), false)).build();
        } else {
            accessor = WailaTickHandler.createEmpty(target);
        }
        if (useRayTraceCallback) {
            EmptyAccessor emptyAccessor;
            Accessor<BlockHitResult> originalAccessor = accessor;
            if (originalAccessor instanceof EmptyAccessor) {
                EmptyAccessor emptyAccessor2 = originalAccessor;
                emptyAccessor = emptyAccessor2;
            } else {
                emptyAccessor = null;
            }
            EmptyAccessor originalEmpty = emptyAccessor;
            for (JadeRayTraceCallback callback : WailaClientRegistration.instance().rayTraceCallback.callbacks()) {
                accessor = callback.onRayTrace(target, accessor, originalAccessor);
                if (accessor != null) continue;
                if (originalEmpty == null) {
                    originalEmpty = WailaTickHandler.createEmpty(originalAccessor.getHitResult());
                }
                accessor = originalEmpty;
            }
        }
        if (!accessor.verifyData(accessor.getServerData())) {
            accessor.setServerData(null);
        }
        ObjectDataCenter.set(accessor);
        AccessorClientHandler<Accessor<?>> handler = WailaClientRegistration.instance().getAccessorHandler(accessor.getAccessorType());
        if (!handler.shouldDisplay(accessor)) {
            this.clearState();
            return;
        }
        this.state = State.create(this.state, accessor, handler, this.state == null ? null : this.state.data);
        if (accessor.isServerConnected()) {
            CompoundTag data = accessor.getServerData();
            accessor.setServerData(null);
            List providers = handler.shouldRequestData(accessor);
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (!providers.isEmpty()) {
                    handler.requestData(accessor, providers);
                }
            }
            if (!providers.isEmpty() && this.getData() == null) {
                return;
            }
            accessor.setServerData(data);
        }
        Theme theme = IWailaConfig.get().overlay().getTheme();
        MutableObject holder = new MutableObject((Object)theme);
        Preconditions.checkNotNull((Object)theme, (Object)"Theme cannot be null");
        Accessor<BlockHitResult> accessor0 = accessor;
        for (JadeBeforeTooltipCollectCallback callback : WailaClientRegistration.instance().beforeTooltipCollectCallback.callbacks()) {
            if (callback.beforeCollecting((MutableObject<Theme>)holder, accessor0)) continue;
            return;
        }
        Preconditions.checkNotNull((Object)((Theme)holder.getValue()), (Object)"Theme cannot be null");
        IThemeHelper themes = IThemeHelper.get();
        if (theme != holder.getValue()) {
            theme = (Theme)holder.getValue();
            themes.setThemeOverride(theme);
        }
        Tooltip tooltip = new Tooltip();
        tooltip.setIcon(this.state.getIcon());
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !ClientProxy.isShowDetailsPressed()) {
            Tooltip dummyTooltip = new Tooltip();
            handler.gatherComponents(accessor, $ -> {
                if (Math.abs(WailaCommonRegistration.instance().priorities.byValue((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            handler.gatherComponents(accessor, $ -> tooltip);
        }
        if (accessor.isServersideContent()) {
            CustomData data = (CustomData)accessor.getServersideRep().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            if (data.tag.contains(REMOVE_ELEMENTS)) {
                List list = data.tag.read(REMOVE_ELEMENTS_CODEC).orElse(List.of());
                for (ResourceLocation tag : list) {
                    tooltip.remove(tag);
                }
            }
        }
        tooltip.setIcon(themes.theme().modifyIcon(tooltip.getIcon()));
        BoxElementImpl newElement = new BoxElementImpl(tooltip, themes.theme().tooltipStyle);
        newElement.tag(JadeIds.ROOT);
        for (JadeTooltipCollectedCallback callback : WailaClientRegistration.instance().tooltipCollectedCallback.callbacks()) {
            callback.onTooltipCollected(newElement, accessor);
        }
        if (this.rootElement == null || this.rootElement.layout.getX() != newElement.layout.getX() || this.rootElement.layout.getY() != newElement.layout.getY() || this.rootElement.layout.getWidth() != newElement.layout.getWidth() || this.rootElement.layout.getHeight() != newElement.layout.getHeight()) {
            OverlayRenderer.animation.startRect.copy(OverlayRenderer.animation.rect);
            OverlayRenderer.animation.startTime = System.currentTimeMillis();
        }
        this.rootElement = newElement;
        themes.setThemeOverride(null);
    }

    private static EmptyAccessor createEmpty(HitResult hit) {
        BlockHitResult miss;
        BlockHitResult blockHitResult;
        if (hit instanceof BlockHitResult && (blockHitResult = (BlockHitResult)hit).getType() == HitResult.Type.MISS) {
            miss = blockHitResult;
        } else {
            Vec3 vec = hit.getLocation();
            miss = BlockHitResult.miss((Vec3)vec, (Direction)Direction.getApproximateNearest((double)vec.x, (double)vec.y, (double)vec.z), (BlockPos)BlockPos.containing((Position)vec));
        }
        return WailaClientRegistration.instance().emptyAccessor().hit(miss).build();
    }

    public void setData(CompoundTag tag) {
        if (this.state == null) {
            return;
        }
        this.state = this.state.withData(tag);
    }

    @Nullable
    public CompoundTag getData() {
        return this.state == null ? null : this.state.data;
    }

    public record State(Accessor<?> accessor, AccessorClientHandler<Accessor<?>> handler, @Nullable CompoundTag data) {
        public static State create(@Nullable State prev, Accessor<?> accessor, AccessorClientHandler<Accessor<?>> handler, @Nullable CompoundTag data) {
            return new State(accessor, handler, data != null && accessor.verifyData(data) ? data : null);
        }

        @Nullable
        public Element getIcon() {
            if (this.accessor == null || this.handler == null) {
                return null;
            }
            Element icon = this.handler.getIcon(this.accessor);
            if (JadeUI.isEmptyElement(icon)) {
                return null;
            }
            return icon;
        }

        public State withData(CompoundTag data) {
            if (!this.verifyData(data)) {
                return this;
            }
            return new State(this.accessor, this.handler, data);
        }

        public boolean verifyData(CompoundTag data) {
            if (data == null) {
                return true;
            }
            return this.accessor.verifyData(data);
        }
    }
}

