/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.impl.BlockAccessorImpl;

public class DatapackBlockManager {
    public static final Logger LOGGER = Jade.LOGGER;
    private static final IntSet displays = IntSets.synchronize((IntSet)IntOpenHashSet.of());

    public static void onEntityJoin(Entity entity) {
        if (DatapackBlockManager.isAcceptableEntity(entity)) {
            displays.add(entity.getId());
        }
    }

    public static void onEntityLeave(Entity entity) {
        if (DatapackBlockManager.isAcceptableEntity(entity)) {
            displays.remove(entity.getId());
        }
    }

    public static ItemStack getFakeBlock(LevelAccessor level, BlockPos pos) {
        if (displays.isEmpty()) {
            return ItemStack.EMPTY;
        }
        List entities = level.getEntitiesOfClass(Display.class, new AABB(pos), DatapackBlockManager::isAcceptableEntity);
        if (!entities.isEmpty()) {
            ItemStack selected = ItemStack.EMPTY;
            float selectedScore = 0.0f;
            for (Display display : entities) {
                Optional itemModel;
                if (!displays.contains(display.getId())) continue;
                ItemStack itemStack = ItemStack.EMPTY;
                if (display instanceof Display.BlockDisplay) {
                    Display.BlockDisplay blockDisplay = (Display.BlockDisplay)display;
                    itemStack = blockDisplay.getBlockState().getCloneItemStack((LevelReader)level, pos, false);
                } else if (display instanceof Display.ItemDisplay) {
                    Display.ItemDisplay itemDisplay = (Display.ItemDisplay)display;
                    itemStack = itemDisplay.getItemStack();
                }
                if (itemStack.isEmpty()) continue;
                float score = 0.0f;
                DataComponentPatch componentsPatch = itemStack.getComponentsPatch();
                Optional customData = componentsPatch.get(DataComponents.CUSTOM_DATA);
                if (customData != null && customData.isPresent()) {
                    CustomData data = (CustomData)customData.get();
                    if (data.tag.contains("$jade:stack")) {
                        score += 10.0f;
                    } else if (data.tag.contains("$polymer:stack")) {
                        score += 2.0f;
                    }
                }
                if ((itemModel = componentsPatch.get(DataComponents.ITEM_MODEL)) != null && itemModel.isPresent()) {
                    score += 1.0f;
                }
                if (!(score > selectedScore)) continue;
                selected = itemStack;
                selectedScore = score;
            }
            return selected;
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public static Accessor<?> override(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        BlockAccessorImpl target;
        if (accessor instanceof BlockAccessorImpl && (target = (BlockAccessorImpl)accessor).getServersideRep().isEmpty()) {
            target.setServersideRep(DatapackBlockManager.getFakeBlock((LevelAccessor)target.getLevel(), target.getPosition()));
        }
        return accessor;
    }

    public static boolean isAcceptableEntity(Entity entity) {
        return entity.getType() == EntityType.BLOCK_DISPLAY || entity.getType() == EntityType.ITEM_DISPLAY;
    }
}

