/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import java.util.function.Predicate;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import snownee.jade.JadeInternals;
import snownee.jade.api.ui.CopyBehavior;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.ResizeableElement;

public class SpacerElement
extends ResizeableElement {
    private LayoutElement wrapped;
    private int wrappedOffsetX;
    private int wrappedOffsetY;
    @Nullable
    private Predicate<? extends LayoutElement> onClick;

    public SpacerElement(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public SpacerElement wrapped(LayoutElement wrapped) {
        this.wrapped = wrapped;
        if (wrapped instanceof Element) {
            Element element = (Element)wrapped;
            if (element.cachedNarration() != null) {
                this.narration(element.cachedNarration());
            } else {
                this.narration("");
            }
            if (this.tag == null) {
                this.tag(element.getTag());
            }
        }
        return this;
    }

    @Override
    @Nullable
    public Component getNarration() {
        return null;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        LayoutElement layoutElement = this.wrapped;
        if (layoutElement instanceof Renderable) {
            Renderable renderable = (Renderable)layoutElement;
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void renderDebug(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Element.RenderDebugContext context) {
        super.renderDebug(graphics, mouseX, mouseY, partialTicks, context);
        LayoutElement layoutElement = this.wrapped;
        if (layoutElement instanceof Element) {
            Element element = (Element)layoutElement;
            element.renderDebug(graphics, mouseX, mouseY, partialTicks, context);
        }
        if (this.wrapped != null) {
            JadeInternals.getDisplayHelper().drawBorder(graphics, this.getRectangle(), 1, -2013265665, true);
        }
    }

    @Override
    public void setFreeSpace(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public SpacerElement offset(int x, int y) {
        this.wrappedOffsetX = x;
        this.wrappedOffsetY = y;
        if (this.wrapped != null && (x != 0 || y != 0)) {
            this.wrapped.setX(x + this.wrappedOffsetX);
            this.wrapped.setY(y + this.wrappedOffsetY);
        }
        return this;
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        if (this.wrapped != null) {
            this.wrapped.setX(x + this.wrappedOffsetX);
        }
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        if (this.wrapped != null) {
            this.wrapped.setY(y + this.wrappedOffsetY);
        }
    }

    @Override
    public ResizeableElement onClick(Predicate<Element> onClick) {
        this.onClick = onClick;
        return this;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.wrapped != null && this.wrapped.getRectangle().containsPoint((int)mouseX, (int)mouseY);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (mouseButtonEvent.button() == 0 && this.onClick != null && this.isMouseOver(mouseButtonEvent.x(), mouseButtonEvent.y())) {
            return this.onClick.test((LayoutElement)this.wrapped);
        }
        return false;
    }

    @Override
    public boolean copyToClipboard(KeyboardHandler keyboardHandler) {
        CopyBehavior behavior;
        LayoutElement layoutElement = this.wrapped;
        if (layoutElement instanceof CopyBehavior && (behavior = (CopyBehavior)layoutElement).copyToClipboard(keyboardHandler)) {
            return true;
        }
        return super.copyToClipboard(keyboardHandler);
    }
}

