/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.theme;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mojang.brigadier.Message;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.addon.core.ModNameProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.TextElement;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.JadeClientCodecs;
import snownee.jade.util.KeyedReloadListener;

public class ThemeHelper
extends SimpleJsonResourceReloadListener<JadeClientCodecs.ThemeHolder>
implements IThemeHelper,
KeyedReloadListener {
    public static final ThemeHelper INSTANCE = new ThemeHelper();
    public static final ResourceLocation ID = JadeIds.JADE("themes");
    private static final Int2ObjectMap<Style> styleCache = new Int2ObjectOpenHashMap(6);
    private final Map<ResourceLocation, Theme> themes = Maps.newTreeMap();
    private final MinMaxBounds.Ints allowedVersions = MinMaxBounds.Ints.between((int)200, (int)299);
    private final Style[] modNameStyleCache = new Style[3];
    private Theme theme;
    private Theme fallback;
    private int generation;
    @Nullable
    private Theme themeOverride;

    public ThemeHelper() {
        super(RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("version").forGetter(JadeClientCodecs.ThemeHolder::version), (App)Codec.BOOL.optionalFieldOf("autoEnable", (Object)false).forGetter(JadeClientCodecs.ThemeHolder::autoEnable), (App)JadeClientCodecs.THEME.forGetter(JadeClientCodecs.ThemeHolder::theme)).apply((Applicative)i, JadeClientCodecs.ThemeHolder::new)), FileToIdConverter.json((String)"jade_themes"));
    }

    public static Style colorStyle(int color) {
        return (Style)styleCache.computeIfAbsent(color, arg_0 -> ((Style)Style.EMPTY).withColor(arg_0));
    }

    @Override
    public Theme theme() {
        return this.themeOverride != null ? this.themeOverride : this.theme;
    }

    @Override
    public Collection<Theme> getThemes() {
        return this.themes.values();
    }

    @Override
    @NotNull
    public Theme getTheme(ResourceLocation id) {
        return (Theme)Preconditions.checkNotNull((Object)this.themes.getOrDefault(id, this.fallback), (String)"Theme not found: %s", (Object)id);
    }

    @Override
    public boolean hasTheme(ResourceLocation id) {
        return this.themes.containsKey(id);
    }

    @Override
    public MutableComponent info(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().info());
    }

    @Override
    public MutableComponent success(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().success());
    }

    @Override
    public MutableComponent warning(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().warning());
    }

    @Override
    public MutableComponent danger(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().danger());
    }

    @Override
    public MutableComponent failure(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().failure());
    }

    @Override
    public MutableComponent title(Object componentOrString) {
        MutableComponent component = componentOrString instanceof MutableComponent ? (MutableComponent)componentOrString : Component.literal((String)Objects.toString(componentOrString));
        return this.color(DisplayHelper.INSTANCE.stripColor((Component)component), this.theme().text.colors().title());
    }

    @Override
    public TextElement modName(Object componentOrString) {
        MutableComponent component = componentOrString instanceof MutableComponent ? (MutableComponent)componentOrString : Component.literal((String)Objects.toString(componentOrString));
        Style itemStyle = IWailaConfig.get().formatting().getItemModNameStyle();
        Style themeStyle = this.theme().text.modNameStyle();
        if (this.modNameStyleCache[0] != itemStyle || this.modNameStyleCache[1] != themeStyle) {
            Style style = itemStyle;
            if (themeStyle != null) {
                style = themeStyle.applyTo(style);
            }
            this.modNameStyleCache[0] = itemStyle;
            this.modNameStyleCache[1] = themeStyle;
            this.modNameStyleCache[2] = style;
        }
        return JadeUI.text((Component)component.withStyle(this.modNameStyleCache[2])).scale(Objects.equals(IWailaConfig.get().plugin().getEnum(JadeIds.CORE_MOD_NAME), (Object)ModNameProvider.Mode.SMALLER) ? 0.75f : 1.0f);
    }

    @Override
    public MutableComponent seconds(int ticks, float tickRate, boolean alwaysOnePart) {
        int seconds = Mth.floor((float)((float)ticks / tickRate));
        if (seconds >= 3600) {
            int hours = seconds / 3600;
            int minutes = (seconds %= 3600) / 60;
            if (alwaysOnePart || minutes == 0) {
                return this.info(JadeClient.format("jade.hours", hours));
            }
            return this.info(JadeClient.format("jade.hours_minutes", hours, minutes));
        }
        if (seconds >= 60) {
            int minutes = seconds / 60;
            if (alwaysOnePart || (seconds %= 60) == 0) {
                return this.info(JadeClient.format("jade.minutes", minutes));
            }
            return this.info(JadeClient.format("jade.minutes_seconds", minutes, seconds));
        }
        return this.info(JadeClient.format("jade.seconds", seconds));
    }

    @Override
    public int generation() {
        return this.generation;
    }

    public void setTheme(Theme theme) {
        if (this.theme == theme) {
            return;
        }
        this.theme = theme;
        ++this.generation;
    }

    @Override
    public void setThemeOverride(@Nullable Theme theme) {
        if (this.themeOverride == theme) {
            return;
        }
        ++this.generation;
        this.themeOverride = theme;
    }

    protected MutableComponent color(Object componentOrString, int color) {
        MutableComponent component;
        if (componentOrString instanceof Number) {
            Number number = (Number)componentOrString;
            componentOrString = DisplayHelper.dfCommas.format(number.doubleValue());
        }
        if (componentOrString instanceof MutableComponent) {
            component = (MutableComponent)componentOrString;
            if (component.getStyle().isEmpty()) {
                return component.setStyle(ThemeHelper.colorStyle(color));
            }
            return component.setStyle(component.getStyle().withColor(color));
        }
        if (componentOrString instanceof Component) {
            component = (Component)componentOrString;
            if (component.getStyle().isEmpty()) {
                return component.copy().setStyle(ThemeHelper.colorStyle(color));
            }
            return component.copy().setStyle(component.getStyle().withColor(color));
        }
        if (componentOrString instanceof Message) {
            Message message = (Message)componentOrString;
            return Component.literal((String)message.getString()).setStyle(ThemeHelper.colorStyle(color));
        }
        return Component.literal((String)Objects.toString(componentOrString)).setStyle(ThemeHelper.colorStyle(color));
    }

    protected void apply(Map<ResourceLocation, JadeClientCodecs.ThemeHolder> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Set<ResourceLocation> existingKeys = Set.copyOf(this.themes.keySet());
        MutableObject enable = new MutableObject();
        WailaConfig.Overlay config = Jade.config().overlay();
        WailaConfig.History history = Jade.history();
        this.themes.clear();
        map.forEach((id, holder) -> {
            if (!this.allowedVersions.matches(holder.version())) {
                Jade.LOGGER.warn("Theme {} has unsupported version {}. Skipping.", id, (Object)holder.version());
                return;
            }
            Theme theme = holder.theme();
            theme.id = id;
            this.themes.put((ResourceLocation)id, theme);
            if (enable.getValue() == null && holder.autoEnable() && !existingKeys.contains(id)) {
                enable.setValue((Object)theme);
            }
        });
        this.fallback = this.themes.get(JadeIds.DEFAULT_THEME);
        if (this.fallback == null) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)new NullPointerException(), (String)"Missing default theme");
            throw new ReportedException(crashreport);
        }
        int hash = 0;
        for (ResourceLocation id2 : this.themes.keySet()) {
            hash = 31 * hash + id2.hashCode();
        }
        if (hash != history.themesHash) {
            if (hash != 0 && enable.getValue() != null) {
                Theme theme = (Theme)enable.getValue();
                config.activeTheme = theme.id;
                Jade.LOGGER.info("Auto enabled theme {}", (Object)theme.id);
                if (theme.changeOpacity != 0.0f) {
                    config.setAlpha(theme.changeOpacity);
                }
            }
            history.themesHash = hash;
            IWailaConfig.get().save();
        }
        config.applyTheme(config.activeTheme);
    }

    @Override
    public ResourceLocation getUid() {
        return ID;
    }
}

