/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config.entry;

import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.InputOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.config.entry.ConfigEntry;

public class IntConfigEntry
extends ConfigEntry<Integer> {
    private boolean slider;
    private int min;
    private int max;

    public IntConfigEntry(ResourceLocation id, int defaultValue, int min, int max, boolean slider) {
        super(id, defaultValue);
        this.slider = slider;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean isValidValue(Object value) {
        return value instanceof Number && ((Number)value).intValue() >= this.min && ((Number)value).intValue() <= this.max;
    }

    @Override
    public Integer convertValue(Object value) {
        return ((Number)value).intValue();
    }

    @Override
    public OptionValue<?> createUI(OptionsList options, String optionName, IPluginConfig config, BiConsumer<ResourceLocation, Object> setter) {
        if (this.slider) {
            return options.slider(optionName, () -> Float.valueOf(config.getFloat(this.id)), f -> setter.accept(this.id, (int)f.floatValue()), this.min, this.max, f -> Math.round(f));
        }
        return options.input(optionName, () -> config.getInt(this.id), i -> setter.accept(this.id, Mth.clamp((int)i, (int)this.min, (int)this.max)), InputOptionValue.INTEGER.and($ -> this.isValidValue(Integer.valueOf($))));
    }
}

