/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationSupplier;
import net.minecraft.client.gui.narration.NarrationThunk;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ITooltip;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.ui.TextElement;
import snownee.jade.impl.ui.JadeUIInternal;

public class Tooltip
implements ITooltip {
    public final List<Line> lines = new ArrayList<Line>();
    public boolean sneakyDetails;
    @Nullable
    public Element icon;

    private static ResourceLocation getTag(LayoutElement element) {
        if (element instanceof Element) {
            Element taggable = (Element)element;
            return taggable.getTag();
        }
        return null;
    }

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    public int size() {
        return this.lines.size();
    }

    @Override
    public void append(int index, LayoutElement element) {
        Element taggable;
        if (element instanceof Element && (taggable = (Element)element).getTag() == null) {
            taggable.tag(JadeUIInternal.contextUid());
        }
        if (this.isEmpty() || index == this.size()) {
            this.add(element);
        } else {
            Line line = this.lines.get(index);
            line.elements.add(element);
        }
    }

    @Override
    public void add(int index, LayoutElement element) {
        this.lines.add(index, new Line());
        this.append(index, element);
    }

    @Override
    public List<LayoutElement> get(ResourceLocation tag) {
        ArrayList elements = Lists.newArrayList();
        for (Line line : this.lines) {
            line.elements().stream().filter(e -> Objects.equal((Object)tag, (Object)Tooltip.getTag(e))).forEach(elements::add);
        }
        return elements;
    }

    @Override
    public boolean remove(ResourceLocation tag) {
        return this.removeInternal(tag, true, null);
    }

    private boolean removeInternal(ResourceLocation tag, boolean removeFirstLineIfEmpty, @Nullable List<List<LayoutElement>> collector) {
        boolean removed = false;
        ArrayList collected = collector == null ? null : Lists.newArrayList();
        Iterator<Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Line line = iterator.next();
            if (!line.elements.removeIf(e -> {
                if (Objects.equal((Object)tag, (Object)Tooltip.getTag(e))) {
                    if (collector != null) {
                        collected.add(e);
                    }
                    return true;
                }
                return false;
            })) continue;
            if (line.elements.isEmpty() && (removed || removeFirstLineIfEmpty)) {
                iterator.remove();
            }
            removed = true;
            if (collector == null || collected.isEmpty()) continue;
            collector.add(Lists.newArrayList((Iterable)collected));
            collected.clear();
        }
        return removed;
    }

    @Override
    public boolean replace(ResourceLocation tag, Component component) {
        return this.replace(tag, $ -> List.of(List.of(JadeUI.text(component))));
    }

    @Override
    public boolean replace(ResourceLocation tag, UnaryOperator<List<List<LayoutElement>>> operator) {
        int firstX = -1;
        int firstY = -1;
        for (int y = 0; y < this.lines.size(); ++y) {
            Line line = this.lines.get(y);
            for (int x = 0; x < line.elements().size(); ++x) {
                LayoutElement element = line.elements().get(x);
                if (!Objects.equal((Object)tag, (Object)Tooltip.getTag(element)) || firstX != -1) continue;
                firstX = x;
                firstY = y;
            }
        }
        if (firstX != -1) {
            List elements = Lists.newArrayList();
            this.removeInternal(tag, false, elements);
            elements = (List)operator.apply(elements);
            for (List elementList : elements) {
                for (LayoutElement element : elementList) {
                    Element taggable;
                    if (!(element instanceof Element) || (taggable = (Element)element).getTag() != null) continue;
                    taggable.tag(tag);
                }
            }
            for (int i = 0; i < elements.size(); ++i) {
                List list = (List)elements.get(i);
                if (i == 0) {
                    Line line = this.lines.get(firstY);
                    line.elements().addAll(firstX, list);
                    continue;
                }
                this.add(firstY + i, list);
            }
        }
        return firstX != -1;
    }

    @Override
    public void setLineMargin(int index, ScreenDirection side, int margin) {
        if (index < 0) {
            index += this.lines.size();
        }
        Line line = this.lines.get(index);
        switch (side) {
            case UP: {
                line.marginTop = margin;
                break;
            }
            case DOWN: {
                line.marginBottom = margin;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only TOP and BOTTOM are allowed.");
            }
        }
    }

    @Override
    public void setLineSettings(int index, UnaryOperator<LayoutSettings> settings) {
        if (index < 0) {
            index += this.lines.size();
        }
        Line line = this.lines.get(index);
        line.settings = settings;
    }

    @Override
    public String getNarration() {
        return this.getNarration(line -> true);
    }

    public String getNarration(Predicate<Line> predicate) {
        final StringBuilder sb = new StringBuilder();
        NarrationElementOutput output = new NarrationElementOutput(){

            public void add(NarratedElementType narratedElementType, NarrationThunk<?> narrationThunk) {
                if (narratedElementType != NarratedElementType.TITLE) {
                    return;
                }
                narrationThunk.getText(text -> sb.append((String)text).append(". "));
            }

            @NotNull
            public NarrationElementOutput nest() {
                return this;
            }
        };
        for (Line line : this.lines) {
            if (!predicate.test(line)) continue;
            boolean hasSupplier = false;
            for (LayoutElement element : line.elements()) {
                if (!(element instanceof NarrationSupplier)) continue;
                NarrationSupplier supplier = (NarrationSupplier)element;
                supplier.updateNarration(output);
                hasSupplier = true;
            }
            if (!hasSupplier || sb.isEmpty()) continue;
            sb.append('\n');
        }
        if (sb.isEmpty()) {
            return "";
        }
        if (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public String getString(ResourceLocation tag) {
        return this.get(tag).stream().filter($ -> $ instanceof TextElement).map($ -> ((TextElement)$).getString()).findFirst().orElse("");
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
        String narration = this.getNarration();
        if (!narration.isEmpty()) {
            narrationElementOutput.add(NarratedElementType.TITLE, narration);
        }
    }

    @Override
    @Nullable
    public Element getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable Element icon) {
        this.icon = icon;
    }

    public static class Line {
        private final List<LayoutElement> elements = Lists.newArrayList();
        public int marginTop = 0;
        public int marginBottom = 2;
        @Nullable
        public UnaryOperator<LayoutSettings> settings;

        public List<LayoutElement> elements() {
            return this.elements;
        }
    }
}

