/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.ui;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.Message;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationSupplier;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import snownee.jade.JadeInternals;
import snownee.jade.api.ui.CopyBehavior;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.api.ui.ResizeableElement;
import snownee.jade.gui.JadeLinearLayout;
import snownee.jade.impl.ui.JadeUIInternal;
import snownee.jade.overlay.DisplayHelper;

public abstract class Element
implements Renderable,
LayoutElement,
NarrationSupplier,
GuiEventListener,
CopyBehavior {
    protected ResourceLocation tag;
    protected int width;
    protected int height;
    private int x;
    private int y;
    @Nullable
    private Component narration = CommonComponents.EMPTY;
    @Nullable
    private UnaryOperator<LayoutSettings> settings;
    @Nullable
    private JadeLinearLayout.Align alignSelf;

    @Contract(value="_, _ -> new")
    public ResizeableElement offset(int x, int y) {
        return JadeUIInternal.offset(this, x, y);
    }

    @Contract(value="_, _ -> new")
    public ResizeableElement size(int width, int height) {
        return JadeUIInternal.size(this, width, height);
    }

    @Contract(value="_ -> new")
    public ResizeableElement onClick(Predicate<Element> onClick) {
        return JadeUIInternal.onClick(this, onClick);
    }

    @Contract(value="_ -> this")
    public Element settings(UnaryOperator<LayoutSettings> settings) {
        this.settings = settings;
        return this;
    }

    @Nullable
    public UnaryOperator<LayoutSettings> getSettings() {
        return this.settings;
    }

    @Contract(value="-> this")
    public Element alignSelfStart() {
        this.alignSelf = JadeLinearLayout.Align.START;
        return this;
    }

    @Contract(value="-> this")
    public Element alignSelfCenter() {
        this.alignSelf = JadeLinearLayout.Align.CENTER;
        return this;
    }

    @Contract(value="-> this")
    public Element alignSelfEnd() {
        this.alignSelf = JadeLinearLayout.Align.END;
        return this;
    }

    @Contract(value="-> this")
    public Element alignSelfStretch() {
        this.alignSelf = JadeLinearLayout.Align.STRETCH;
        return this;
    }

    @Nullable
    public JadeLinearLayout.Align getAlignSelf() {
        return this.alignSelf;
    }

    @Contract(value="_ -> this")
    public Element tag(@Nullable ResourceLocation tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    public ResourceLocation getTag() {
        return this.tag;
    }

    @Nullable
    public Component cachedNarration() {
        if (this.narration == CommonComponents.EMPTY) {
            this.narration = this.getNarration();
        }
        return this.narration;
    }

    @Nullable
    public abstract Component getNarration();

    @Contract(value="-> this")
    public Element refreshNarration() {
        this.narration = CommonComponents.EMPTY;
        return this;
    }

    @Contract(value="_ -> this")
    public Element narration(String narration) {
        Preconditions.checkNotNull((Object)narration, (Object)"narration must not be null");
        this.narration = narration.isEmpty() ? null : Component.literal((String)narration);
        return this;
    }

    @Contract(value="_ -> this")
    public Element narration(Component narration) {
        Preconditions.checkNotNull((Object)narration, (Object)"narration must not be null");
        this.narration = narration;
        return this;
    }

    public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final ScreenRectangle getRectangle() {
        return super.getRectangle();
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
        Component message = this.cachedNarration();
        if (message != null) {
            narrationElementOutput.add(NarratedElementType.TITLE, message);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.getHeight());
    }

    public void setFocused(boolean bl) {
    }

    public boolean isFocused() {
        return false;
    }

    @Override
    public boolean copyToClipboard(KeyboardHandler keyboardHandler) {
        Element element = this;
        if (element instanceof Message) {
            Message message = (Message)element;
            keyboardHandler.setClipboard(message.getString());
            return true;
        }
        Component component = this.cachedNarration();
        if (component != null) {
            keyboardHandler.setClipboard(component.getString());
            return true;
        }
        return false;
    }

    public void renderDebug(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, RenderDebugContext context) {
        JadeInternals.getDisplayHelper().drawBorder(graphics, this.getRectangle(), 1, -1996554240, true);
        if (JadeUI.hasAltDown() && this.getTag() != null) {
            int centerX = context.root.getX() + context.root.getWidth() / 2;
            int x = this.getX();
            int y = this.getY();
            String s = this.getTag().toString();
            int textWidth = DisplayHelper.font().width(s);
            Matrix3x2fStack pose = graphics.pose();
            pose.pushMatrix();
            pose.translate((float)x, (float)y);
            pose.scale(0.5f);
            if (x > centerX) {
                pose.translate((float)(this.getWidth() + this.getWidth()), 0.0f);
            } else {
                pose.translate((float)(-textWidth - 4), 0.0f);
            }
            Objects.requireNonNull(DisplayHelper.font());
            graphics.fill(0, 0, textWidth + 4, 9 + 4, -2013265920);
            graphics.drawString(DisplayHelper.font(), s, 2, 2, -1, false);
            pose.popMatrix();
        }
    }

    public static class RenderDebugContext {
        public final LayoutElement root;
        public final Rect2f rootRect;
        public final boolean renderChildren;

        public RenderDebugContext(LayoutElement root, Rect2f rootRect, boolean renderChildren) {
            this.root = root;
            this.rootRect = rootRect;
            this.renderChildren = renderChildren;
        }
    }
}

