/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.narration.NarrationSupplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.ScreenDirection;

@ApiStatus.NonExtendable
public interface ITooltip
extends NarrationSupplier {
    public void clear();

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public void add(Component component) {
        this.add(component, null);
    }

    default public void add(Component component, ResourceLocation tag) {
        this.add(this.size(), component, tag);
    }

    default public void add(int index, Component component) {
        this.add(index, component, null);
    }

    default public void add(int index, Component component, ResourceLocation tag) {
        this.add(index, JadeUI.text(component).tag(tag));
    }

    default public void addAll(List<Component> components) {
        components.forEach(this::add);
    }

    default public void add(LayoutElement element) {
        this.add(this.size(), element);
    }

    default public void add(int index, List<? extends LayoutElement> elements) {
        boolean first = true;
        for (LayoutElement layoutElement : elements) {
            if (first) {
                this.add(index, layoutElement);
            } else {
                this.append(index, layoutElement);
            }
            first = false;
        }
    }

    default public void add(List<? extends LayoutElement> elements) {
        this.add(this.size(), elements);
    }

    public void add(int var1, LayoutElement var2);

    default public void append(Component component) {
        this.append(component, null);
    }

    default public void append(Component component, ResourceLocation tag) {
        this.append(JadeUI.text(component).tag(tag));
    }

    default public void append(LayoutElement element) {
        this.append(this.size() - 1, element);
    }

    default public void append(int index, List<? extends LayoutElement> elements) {
        for (LayoutElement layoutElement : elements) {
            this.append(index, layoutElement);
        }
    }

    public void append(int var1, LayoutElement var2);

    public boolean remove(ResourceLocation var1);

    public boolean replace(ResourceLocation var1, UnaryOperator<List<List<LayoutElement>>> var2);

    public boolean replace(ResourceLocation var1, Component var2);

    public List<LayoutElement> get(ResourceLocation var1);

    public void setLineMargin(int var1, ScreenDirection var2, int var3);

    public void setLineSettings(int var1, UnaryOperator<LayoutSettings> var2);

    public String getNarration();

    public String getString(ResourceLocation var1);

    @Nullable
    public Element getIcon();
}

