/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.TraceableException;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.impl.ui.TextElementImpl;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.WailaExceptionHandler;

public class ItemTooltipProvider
implements IEntityComponentProvider {
    public static final ItemTooltipProvider INSTANCE = new ItemTooltipProvider();

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        ItemStack stack = ((ItemEntity)accessor.getEntity()).getItem();
        Item.TooltipContext tooltipContext = Item.TooltipContext.of((Level)accessor.getLevel());
        ArrayList lines = Lists.newArrayList();
        try {
            stack.getTooltipLines(tooltipContext, null, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().peek(component -> {
                MutableComponent mutable;
                if (component instanceof MutableComponent && (mutable = (MutableComponent)component).getStyle().getColor() != null) {
                    mutable.setStyle(mutable.getStyle().withColor((TextColor)null));
                }
            }).map(Either::left).forEach(lines::add);
        }
        catch (Throwable e) {
            String namespace = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace();
            WailaExceptionHandler.handleErr(TraceableException.create(e, namespace), this, tooltip::add);
        }
        if (lines.isEmpty()) {
            return;
        }
        List<FormattedText> realLines = lines.stream().map($ -> $.left()).filter(Optional::isPresent).map(Optional::get).skip(1L).toList();
        String modName = ModIdentification.getModName(stack);
        Font font = DisplayHelper.font();
        int maxWidth = 250;
        for (FormattedText text : realLines) {
            if (Objects.equals(ChatFormatting.stripFormatting((String)text.getString()), modName)) continue;
            int width = font.width(text);
            if (width > maxWidth) {
                tooltip.add((Component)Component.literal((String)(font.substrByWidth(text, maxWidth - 5).getString() + "..")));
                continue;
            }
            tooltip.add(new TextElementImpl(text));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_ITEM_TOOLTIP;
    }
}

