/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class ItemStorageProvider<T extends Accessor<?>>
implements IServerDataProvider<T> {
    public static final Cache<Object, ItemCollector<?>> targetCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public static final Cache<Object, ItemCollector<?>> containerCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(120L, TimeUnit.SECONDS).build();
    private static final StreamCodec<RegistryFriendlyByteBuf, Map.Entry<ResourceLocation, List<ViewGroup<ItemStack>>>> STREAM_CODEC = ViewGroup.listCodec(ItemStack.OPTIONAL_STREAM_CODEC);
    public static final ItemStorageProvider<BlockAccessor> BLOCK = new ItemStorageProvider();
    public static final ItemStorageProvider<EntityAccessor> ENTITY = new ItemStorageProvider();

    public static void putData(Accessor<?> accessor) {
        ContainerEntity containerEntity;
        RandomizableContainer containerEntity2;
        CompoundTag tag = accessor.getServerData();
        Object target = accessor.getTarget();
        Player player = accessor.getPlayer();
        Map.Entry entry = CommonProxy.getServerExtensionData(accessor, WailaCommonRegistration.instance().itemStorageProviders);
        if (entry != null) {
            List groups = entry.getValue();
            for (ViewGroup group : groups) {
                if (group.views.size() <= 54) continue;
                group.views = group.views.subList(0, 54);
            }
            tag.put(JadeIds.UNIVERSAL_ITEM_STORAGE.toString(), accessor.encodeAsNbt(STREAM_CODEC, entry));
            return;
        }
        if (target instanceof RandomizableContainer && (containerEntity2 = (RandomizableContainer)target).getLootTable() != null) {
            tag.putBoolean("Loot", true);
        } else if (target instanceof ContainerEntity && (containerEntity = (ContainerEntity)target).getContainerLootTable() != null) {
            tag.putBoolean("Loot", true);
        } else if (!player.isCreative() && !player.isSpectator() && target instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity te = (BaseContainerBlockEntity)target;
            if (te.lockKey != LockCode.NO_LOCK) {
                tag.putBoolean("Locked", true);
            }
        }
    }

    @Override
    public void appendServerData(CompoundTag tag, T accessor) {
        if (accessor.getTarget() instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        ItemStorageProvider.putData(accessor);
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        if (accessor.getTarget() instanceof AbstractFurnaceBlockEntity) {
            return false;
        }
        int amount = accessor.showDetails() ? IWailaConfig.get().plugin().getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_DETAILED_AMOUNT) : IWailaConfig.get().plugin().getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_NORMAL_AMOUNT);
        if (amount == 0) {
            return false;
        }
        if (IWailaConfig.get().plugin().get(JadeIds.UNIVERSAL_ITEM_STORAGE_SORT)) {
            accessor.getServerData().putBoolean("SortItems", true);
        }
        return WailaCommonRegistration.instance().itemStorageProviders.hitsAny((Accessor<?>)accessor, (BiPredicate<IServerExtensionProvider<ItemStack>, Accessor<?>>)((BiPredicate<IServerExtensionProvider, Accessor>)IServerExtensionProvider::shouldRequestData));
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.UNIVERSAL_ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    public static class Extension
    implements IServerExtensionProvider<ItemStack>,
    IClientExtensionProvider<ItemStack, ItemView> {
        public static final Extension INSTANCE = new Extension();

        @Override
        public ResourceLocation getUid() {
            return JadeIds.UNIVERSAL_ITEM_STORAGE_DEFAULT;
        }

        @Override
        @Nullable
        public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor) {
            ItemCollector itemCollector;
            ContainerEntity containerEntity;
            RandomizableContainer te;
            Object target = accessor.getTarget();
            if (target == null) {
                return CommonProxy.createItemCollector(accessor, containerCache).update(accessor);
            }
            if (target instanceof RandomizableContainer && (te = (RandomizableContainer)target).getLootTable() != null) {
                return null;
            }
            if (target instanceof ContainerEntity && (containerEntity = (ContainerEntity)target).getContainerLootTable() != null) {
                return null;
            }
            Player player = accessor.getPlayer();
            if (!player.isCreative() && !player.isSpectator() && target instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity te2 = (BaseContainerBlockEntity)target;
                if (te2.lockKey != LockCode.NO_LOCK) {
                    return null;
                }
            }
            if (target instanceof EnderChestBlockEntity) {
                PlayerEnderChestContainer inventory = player.getEnderChestInventory();
                return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator($ -> inventory, 0)).update(accessor);
            }
            try {
                itemCollector = (ItemCollector)targetCache.get(target, () -> CommonProxy.createItemCollector(accessor, containerCache));
            }
            catch (ExecutionException e) {
                WailaExceptionHandler.handleErr(e, this, null);
                return null;
            }
            return itemCollector.update(accessor);
        }

        @Override
        public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
            return ClientViewGroup.map(groups, ItemView::new, null);
        }

        @Override
        public boolean shouldRequestData(Accessor<?> accessor) {
            Object target = accessor.getTarget();
            if (target instanceof EnderChestBlockEntity || target instanceof Container) {
                return true;
            }
            return CommonProxy.hasDefaultItemStorage(accessor);
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }
    }

    public static class Client<T extends Accessor<?>>
    extends ItemStorageProvider<T>
    implements IComponentProvider<T> {
        public static final Client<BlockAccessor> BLOCK = new Client();
        public static final Client<EntityAccessor> ENTITY = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
            if (accessor.getTarget() instanceof AbstractFurnaceBlockEntity) {
                return;
            }
            Client.append(tooltip, accessor, config);
        }

        public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
            if (!accessor.getServerData().contains(JadeIds.UNIVERSAL_ITEM_STORAGE.toString())) {
                if (accessor.getServerData().getBooleanOr("Loot", false)) {
                    tooltip.add((Component)Component.translatable((String)"jade.loot_not_generated"));
                } else if (accessor.getServerData().getBooleanOr("Locked", false)) {
                    tooltip.add((Component)Component.translatable((String)"jade.locked"));
                }
                return;
            }
            List groups = ClientProxy.mapToClientGroups(accessor, JadeIds.UNIVERSAL_ITEM_STORAGE, STREAM_CODEC, WailaClientRegistration.instance().itemStorageProviders::get, tooltip);
            if (groups == null || groups.isEmpty()) {
                return;
            }
            MutableBoolean showName = new MutableBoolean(true);
            MutableInt amountWidth = new MutableInt();
            int showNameAmount = config.getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_SHOW_NAME_AMOUNT);
            int totalSize = 0;
            for (ClientViewGroup clientViewGroup : groups) {
                for (ItemView view : clientViewGroup.views) {
                    if (view.amountText != null) {
                        showName.setFalse();
                    }
                    if (!view.item.isEmpty() && ++totalSize == showNameAmount) {
                        showName.setFalse();
                    }
                    if (!showName.isTrue()) continue;
                    String s = IDisplayHelper.get().humanReadableNumber(view.item.getCount(), "", false, null);
                    amountWidth.setValue(Math.max(amountWidth.intValue(), Minecraft.getInstance().font.width(s)));
                }
            }
            boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
            ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
                float progress;
                if (renderGroup) {
                    theTooltip.add(new HorizontalLineElement());
                    if (group.title != null) {
                        theTooltip.append(JadeUI.text(group.title).scale(0.5f));
                        theTooltip.append(new HorizontalLineElement().flexGrow(1));
                    }
                }
                if (group.views.isEmpty() && group.extraData != null && (progress = group.extraData.getFloatOr("Collecting", -1.0f)) >= 0.0f && progress < 1.0f) {
                    MutableComponent component = Component.translatable((String)"jade.collectingItems");
                    if (progress != 0.0f) {
                        component.append(" %s%%".formatted((int)(progress * 100.0f)));
                    }
                    theTooltip.add((Component)component);
                }
                int drawnCount = 0;
                int realSize = config.getInt(accessor.showDetails() ? JadeIds.UNIVERSAL_ITEM_STORAGE_DETAILED_AMOUNT : JadeIds.UNIVERSAL_ITEM_STORAGE_NORMAL_AMOUNT);
                realSize = Math.min(group.views.size(), realSize);
                ArrayList elements = Lists.newArrayList();
                for (int i = 0; i < realSize; ++i) {
                    ItemView itemView = (ItemView)group.views.get(i);
                    ItemStack stack = itemView.item;
                    if (stack.isEmpty()) continue;
                    if (i > 0 && (showName.isTrue() || drawnCount >= config.getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_ITEMS_PER_LINE))) {
                        theTooltip.add(elements);
                        theTooltip.setLineMargin(-1, ScreenDirection.DOWN, 0);
                        elements.clear();
                        drawnCount = 0;
                    }
                    if (showName.isTrue()) {
                        if (itemView.description != null) {
                            elements.add(JadeUI.smallItem(stack));
                            elements.addAll(itemView.description);
                        } else {
                            elements.add(JadeUI.smallItem(stack).refreshNarration());
                            String s = IDisplayHelper.get().humanReadableNumber(stack.getCount(), "", false, null);
                            int width = Minecraft.getInstance().font.width(s);
                            if (width < amountWidth.intValue()) {
                                elements.add(JadeUI.spacer(amountWidth.intValue() - width, 0));
                            }
                            elements.add(JadeUI.text((Component)Component.literal((String)s).append("\u00d7 ").append((Component)IDisplayHelper.get().stripColor(stack.getHoverName()))).narration(""));
                        }
                    } else if (itemView.amountText != null) {
                        elements.add(JadeUI.item(stack, 1.0f, itemView.amountText));
                    } else {
                        elements.add(JadeUI.item(stack));
                    }
                    ++drawnCount;
                }
                if (!elements.isEmpty()) {
                    theTooltip.add(elements);
                }
            });
        }
    }
}

