/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import com.mojang.datafixers.util.Either;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import snownee.jade.addon.access.EntityVariantHelper;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;

public class EntityVariantProvider
implements IEntityComponentProvider {
    private static final Map<Markings, String> MARKINGS = Map.of(Markings.NONE, "none", Markings.WHITE, "white", Markings.WHITE_FIELD, "white_field", Markings.WHITE_DOTS, "white_dots", Markings.BLACK_DOTS, "black_dots");

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Entity entity = accessor.getEntity();
        Either<String, Component> variantName = EntityVariantHelper.getVariantName(entity, false);
        if (variantName == null) {
            return;
        }
        variantName.ifLeft(s -> {
            String type = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toShortLanguageKey();
            String key = "jade.access.entity.%s.%s".formatted(type, s);
            s = I18n.exists((String)key) || config.get(JadeIds.DEBUG_SPECIAL_REGISTRY_NAME) && !accessor.showDetails() ? I18n.get((String)key, (Object[])new Object[0]) : s.replace('.', ' ').replace('_', ' ');
            tooltip.add((Component)Component.translatable((String)"jade.access.entity.variant", (Object[])new Object[]{s}));
        }).ifRight(component -> tooltip.add((Component)Component.translatable((String)"jade.access.entity.variant", (Object[])new Object[]{component})));
        if (entity instanceof Horse) {
            String key;
            Horse horse = (Horse)entity;
            Markings markings = horse.getMarkings();
            String s2 = MARKINGS.get(markings);
            if (s2 == null) {
                s2 = markings.name();
            }
            s2 = I18n.exists((String)(key = "jade.access.entity.horse_markings.%s".formatted(s2))) || config.get(JadeIds.DEBUG_SPECIAL_REGISTRY_NAME) && !accessor.showDetails() ? I18n.get((String)key, (Object[])new Object[0]) : s2.replace('_', ' ');
            tooltip.add((Component)Component.translatable((String)"jade.access.entity.horse_markings", (Object[])new Object[]{s2}));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.ACCESS_ENTITY_VARIANT;
    }
}

