/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.impl.common.sailing;

import com.cursee.monolib.Constants;
import com.cursee.monolib.MonoLib;
import com.cursee.monolib.impl.common.sailing.SailingEntry;
import com.cursee.monolib.impl.common.sailing.SailingImpl;
import com.cursee.monolib.impl.common.sailing.SailingMessage;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;

public class SailingClientHelper {
    public static void onPlayerJoinClientLevel(LocalPlayer player, ClientLevel level) {
        if (player != Minecraft.getInstance().player) {
            return;
        }
        boolean ENTITY_CHECKED = player.getTags().contains("monolib.sailing");
        if (!MonoLib.shouldVerifyMods || SailingImpl.verified || ENTITY_CHECKED) {
            return;
        }
        SailingClientHelper.verifyModFiles(player);
        player.addTag("monolib.sailing");
    }

    private static void verifyModFiles(LocalPlayer player) {
        List<String> MOD_NAMES_MISSING_JAR_FILE = SailingImpl.getModNamesMissingJarFile();
        if (!MOD_NAMES_MISSING_JAR_FILE.isEmpty() && SailingImpl.preVerificationProcess()) {
            SailingMessage.sendMessage((Player)player, "Mod(s) from incorrect sources:", ChatFormatting.RED);
            for (String modName : MOD_NAMES_MISSING_JAR_FILE) {
                SailingEntry entry = SailingImpl.MOD_NAME_TO_ENTRY.get(modName);
                SailingMessage.sendMessage((Player)player, modName + " by " + entry.modPublisher() + " (Click Here)", ChatFormatting.YELLOW, entry.modURL());
            }
            SailingMessage.sendMessage((Player)player, "You a receiving this message because one or more of your mod files has been altered and possibly not downloaded from an original and safe source. Unofficial sources can contain malicious software or host outdated versions of mods, as well as removing ad revenue from mod authors.", ChatFormatting.RED);
            SailingMessage.sendMessage((Player)player, "Click on the name of the mod above to find it's original posting.", ChatFormatting.DARK_GREEN);
            SailingMessage.sendMessage((Player)player, "You won't see this message again in this instance. Thank you for reading.", ChatFormatting.DARK_GREEN);
            Constants.LOG.info("You a receiving this message because one or more of your mod files has been altered and possibly not downloaded from an original and safe source. Unofficial sources can contain malicious software or host outdated versions of mods, as well as removing ad revenue from mod authors.");
            Constants.LOG.info("Click on the name of the mod above to find it's original posting.");
            Constants.LOG.info("You won't see this message again in this instance. Thank you for reading.");
            SailingImpl.postVerificationProcess();
        }
        SailingImpl.verified = true;
    }
}

