/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.item;

import com.tristankechlo.livingthings.entity.projectile.ThrownOstrichEgg;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public class OstrichEggItem
extends Item
implements ProjectileItem {
    public OstrichEggItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        world.playSound(null, player.blockPosition(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide()) {
            ThrownOstrichEgg thrownEgg = new ThrownOstrichEgg((LivingEntity)player, world, stack);
            thrownEgg.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)thrownEgg);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new ThrownOstrichEgg(pos.x(), pos.y(), pos.z(), level, stack);
    }
}

