/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.block.OstrichNestBlock;
import com.tristankechlo.livingthings.config.entity.OstrichConfig;
import com.tristankechlo.livingthings.entity.ai.OstrichBreedGoal;
import com.tristankechlo.livingthings.init.ModBlocks;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import com.tristankechlo.livingthings.util.Predicates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class OstrichEntity
extends Animal
implements ItemSteerable,
ILexiconEntry {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_BUILDING_NEST = SynchedEntityData.defineId(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_LAYING_EGG = SynchedEntityData.defineId(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.defineId(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.defineId(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ItemBasedSteering boostHelper;
    private int nestBuildingCounter;
    private int layingEggCounter;

    public OstrichEntity(EntityType<? extends OstrichEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.boostHelper = new ItemBasedSteering(this.entityData, BOOST_TIME);
    }

    public static boolean checkOstrichSpawnRules(EntityType<OstrichEntity> animal, LevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.OSTRICH_SPAWNABLE_ON) && OstrichEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob parent) {
        return (AgeableMob)ModEntityTypes.OSTRICH.get().create((Level)world, EntitySpawnReason.BREEDING);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.TEMPT_RANGE, OstrichConfig.temptRange()).add(Attributes.MAX_HEALTH, OstrichConfig.health()).add(Attributes.MOVEMENT_SPEED, OstrichConfig.movementSpeed());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new OstrichBreedGoal(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LayEggGoal(this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Predicates.OSTRICH_FOOD, false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.3));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, OstrichEntity.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_EGG, (Object)false);
        builder.define(IS_BUILDING_NEST, (Object)false);
        builder.define(IS_LAYING_EGG, (Object)false);
        builder.define(SADDLED, (Object)true);
        builder.define(BOOST_TIME, (Object)0);
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HasEgg", this.hasEgg());
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.setHasEgg(compound.getBooleanOr("HasEgg", false));
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && this.isBuildingNest() && this.nestBuildingCounter >= 1 && this.nestBuildingCounter % 7 == 0) {
            BlockPos pos = this.blockPosition();
            this.level().levelEvent(2001, pos, Block.getId((BlockState)Blocks.SAND.defaultBlockState()));
        }
    }

    public int getMaxSpawnClusterSize() {
        return OstrichConfig.maxSpawnedInChunk();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (BOOST_TIME.equals(key) && this.level().isClientSide()) {
            this.boostHelper.onSynced();
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.OSTRICH_FOOD);
    }

    protected void dropEquipment(ServerLevel level) {
        super.dropEquipment(level);
        if (this.hasEgg()) {
            this.spawnAtLocation(level, (ItemLike)ModItems.OSTRICH_EGG.get());
        }
    }

    public boolean isBuildingNest() {
        return (Boolean)this.entityData.get(IS_BUILDING_NEST);
    }

    public void setBuildingNest(boolean building) {
        this.nestBuildingCounter = building ? 1 : 0;
        this.entityData.set(IS_BUILDING_NEST, (Object)building);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.entityData.get(IS_LAYING_EGG);
    }

    public void setLayingEgg(boolean layingEgg) {
        this.layingEggCounter = layingEgg ? 1 : 0;
        this.entityData.set(IS_LAYING_EGG, (Object)layingEgg);
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.OSTRICH_AMBIENT.get();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean isLexicon;
        boolean breedingItem = this.isFood(player.getItemInHand(hand));
        boolean bl = isLexicon = player.getMainHandItem().getItem() == ModItems.LEXICON.get();
        if (!(breedingItem || isLexicon || this.isVehicle() || this.isBaby() || player.isSecondaryUseActive())) {
            if (!this.level().isClientSide() && OstrichConfig.canBeRidden()) {
                player.startRiding((Entity)this);
                return InteractionResult.SUCCESS_SERVER;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public LivingEntity getControllingPassenger() {
        Entity passenger = this.getFirstPassenger();
        if (passenger instanceof Player) {
            return (Player)passenger;
        }
        return null;
    }

    public boolean boost() {
        return this.boostHelper.boost(this.getRandom());
    }

    protected void tickRidden(Player player, Vec3 vec3) {
        super.tickRidden(player, vec3);
        this.setRot(player.getYRot(), player.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.boostHelper.tickBoost();
    }

    protected Vec3 getPassengerAttachmentPoint(Entity rider, EntityDimensions dimensions, float scale) {
        return new Vec3(0.0, (double)(dimensions.height() * 0.7f * scale), 0.0);
    }

    protected Vec3 getRiddenInput(Player player, Vec3 travelVec) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float getRiddenSpeed(Player player) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.9f;
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.OSTRICH;
    }

    private static class LayEggGoal
    extends MoveToBlockGoal {
        private final OstrichEntity ostrich;
        private boolean isAboveDestination;

        public LayEggGoal(OstrichEntity creature, double speedIn) {
            super((PathfinderMob)creature, speedIn, 16);
            this.ostrich = creature;
        }

        public boolean canUse() {
            return (this.ostrich.hasEgg() || this.ostrich.isBuildingNest() || this.ostrich.isLayingEgg()) && super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && (this.ostrich.hasEgg() || this.ostrich.isBuildingNest() || this.ostrich.isLayingEgg());
        }

        protected void moveMobToBlock() {
            BlockPos blockpos = this.getMoveToTarget();
            Path path = this.mob.getNavigation().createPath((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5, 0);
            this.mob.getNavigation().moveTo(path, this.speedModifier);
        }

        protected BlockPos getMoveToTarget() {
            if (this.ostrich.level().getBlockState(this.blockPos).getBlock() == ModBlocks.OSTRICH_NEST.get()) {
                return this.blockPos;
            }
            return this.blockPos.above();
        }

        public void tick() {
            BlockPos blockpos = this.getMoveToTarget();
            if (!blockpos.closerToCenterThan((Position)this.mob.position(), this.acceptedDistance())) {
                this.isAboveDestination = false;
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    Path path = this.mob.getNavigation().createPath((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5, 0);
                    this.mob.getNavigation().moveTo(path, this.speedModifier);
                }
            } else {
                this.isAboveDestination = true;
                --this.tryTicks;
            }
            if (!this.ostrich.isInWater() && this.isReachedTarget()) {
                Level world = this.ostrich.level();
                if (world.getBlockState(this.blockPos).getBlock() == ModBlocks.OSTRICH_NEST.get()) {
                    BlockState state = world.getBlockState(this.blockPos);
                    if (!((Boolean)state.getValue((Property)OstrichNestBlock.EGG)).booleanValue()) {
                        if (this.ostrich.layingEggCounter < 1) {
                            this.ostrich.setLayingEgg(true);
                        } else if (this.ostrich.layingEggCounter > 150) {
                            world.playSound(null, this.blockPos, ModSounds.OSTRICH_EGG_LAYING.get(), SoundSource.BLOCKS, 0.5f, 0.9f);
                            world.setBlock(this.blockPos, (BlockState)state.setValue((Property)OstrichNestBlock.EGG, (Comparable)Boolean.valueOf(true)), 3);
                            this.ostrich.setHasEgg(false);
                            this.ostrich.setLayingEgg(false);
                        }
                        if (this.ostrich.isLayingEgg()) {
                            ++this.ostrich.layingEggCounter;
                        }
                    }
                } else {
                    if (this.ostrich.nestBuildingCounter < 1) {
                        this.ostrich.setBuildingNest(true);
                    } else if (this.ostrich.nestBuildingCounter > 100) {
                        world.playSound(null, this.blockPos, SoundEvents.LILY_PAD_PLACE, SoundSource.BLOCKS, 0.9f, 0.9f);
                        world.setBlock(this.blockPos.above(), ModBlocks.OSTRICH_NEST.get().defaultBlockState(), 3);
                        this.blockPos = this.blockPos.above();
                        this.ostrich.setBuildingNest(false);
                    }
                    if (this.ostrich.isBuildingNest()) {
                        ++this.ostrich.nestBuildingCounter;
                    }
                }
            } else {
                this.ostrich.setLayingEgg(false);
                this.ostrich.setBuildingNest(false);
            }
        }

        public void stop() {
            super.stop();
            this.ostrich.setLayingEgg(false);
            this.ostrich.setBuildingNest(false);
        }

        protected boolean isReachedTarget() {
            return this.isAboveDestination;
        }

        protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
            if (worldIn.getBlockState(pos).getBlock() == ModBlocks.OSTRICH_NEST.get()) {
                return (Boolean)worldIn.getBlockState(pos).getValue((Property)OstrichNestBlock.EGG) == false;
            }
            if (worldIn.getBlockState(pos).getBlock() == Blocks.SAND) {
                return worldIn.isEmptyBlock(pos.above());
            }
            return false;
        }
    }
}

