/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config;

import com.google.common.collect.ImmutableMap;
import com.tristankechlo.livingthings.config.entity.CrabConfig;
import com.tristankechlo.livingthings.config.entity.ElephantConfig;
import com.tristankechlo.livingthings.config.entity.FlamingoConfig;
import com.tristankechlo.livingthings.config.entity.GiraffeConfig;
import com.tristankechlo.livingthings.config.entity.KoalaConfig;
import com.tristankechlo.livingthings.config.entity.LionConfig;
import com.tristankechlo.livingthings.config.entity.MantarayConfig;
import com.tristankechlo.livingthings.config.entity.MonkeyConfig;
import com.tristankechlo.livingthings.config.entity.OstrichConfig;
import com.tristankechlo.livingthings.config.entity.OwlConfig;
import com.tristankechlo.livingthings.config.entity.PeacockConfig;
import com.tristankechlo.livingthings.config.entity.PenguinConfig;
import com.tristankechlo.livingthings.config.entity.RaccoonConfig;
import com.tristankechlo.livingthings.config.entity.SeahorseConfig;
import com.tristankechlo.livingthings.config.entity.SharkConfig;
import com.tristankechlo.livingthings.config.entity.ShroomieConfig;
import com.tristankechlo.livingthings.config.entity.SnailConfig;
import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.BooleanValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;

public final class GeneralConfig
extends EntityConfig {
    private static final GeneralConfig INSTANCE = new GeneralConfig();
    public final BooleanValue ambientMode = new BooleanValue("ambientMode", false);
    public final BooleanValue doBananaDrops = new BooleanValue("doBananaDrops", true);
    public final NumberValue.DoubleValue bananaDropChance = new NumberValue.DoubleValue("bananaDropChance", 45.0, 0.0, 100.0);

    private GeneralConfig() {
        super("livingthings");
        this.registerConfigValues(this.ambientMode, this.doBananaDrops, this.bananaDropChance);
    }

    public static GeneralConfig get() {
        return INSTANCE;
    }

    public static Map<ResourceLocation, List<Weighted<MobSpawnSettings.SpawnerData>>> getSpawnData() {
        HashMap<ResourceLocation, List<Weighted<MobSpawnSettings.SpawnerData>>> hashMap = new HashMap<ResourceLocation, List<Weighted<MobSpawnSettings.SpawnerData>>>();
        GeneralConfig.getDefaults().forEach((entityType, spawnDataSupplier) -> ((List)spawnDataSupplier.get()).forEach(spawnData -> spawnData.getBiomes().forEach(biome -> {
            List spawnDataList = hashMap.getOrDefault(biome, new ArrayList());
            spawnDataList.add(spawnData.asSpawnerData((EntityType<?>)entityType));
            hashMap.put((ResourceLocation)biome, spawnDataList);
        })));
        return hashMap;
    }

    private static Map<EntityType<?>, Supplier<List<SpawnData>>> getDefaults() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ModEntityTypes.CRAB.get(), CrabConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.ELEPHANT.get(), ElephantConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.FLAMINGO.get(), FlamingoConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.GIRAFFE.get(), GiraffeConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.KOALA.get(), KoalaConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.LION.get(), LionConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.MANTARAY.get(), MantarayConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.MONKEY.get(), MonkeyConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.OSTRICH.get(), OstrichConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.OWL.get(), OwlConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.PENGUIN.get(), PenguinConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.RACCOON.get(), RaccoonConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.SEAHORSE.get(), SeahorseConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.SHARK.get(), SharkConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.SHROOMIE.get(), ShroomieConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.SNAIL.get(), SnailConfig.get().spawnBiomes::get);
        builder.put(ModEntityTypes.PEACOCK.get(), PeacockConfig.get().spawnBiomes::get);
        return builder.build();
    }
}

