/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class PenguinModel
extends AdvancedEntityModel<LivingEntityRenderState> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Beak;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private final ModelPart LeftFeet;
    private final ModelPart RightFeet;

    public PenguinModel(ModelPart root) {
        super(root);
        this.Body = root.getChild("Body");
        this.Head = root.getChild("Head");
        this.Beak = this.Head.getChild("Beak");
        this.LeftWing = this.Body.getChild("LeftWing");
        this.RightWing = this.Body.getChild("RightWing");
        this.LeftFeet = this.Body.getChild("LeftFeet");
        this.RightFeet = this.Body.getChild("RightFeet");
    }

    @Override
    protected void animate(LivingEntityRenderState state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.defaultHeadMovement(this.Head, 0.0f, 0.0f, headPitch, netHeadYaw);
        this.Body.zRot = Mth.cos((float)(limbSwing * 1.3324f)) * 0.75f * limbSwingAmount / 7.0f;
        this.RightWing.zRot = 0.1308997f + (0.78726643f + Mth.cos((float)(limbSwing * 0.6662f)) * 1.0f) * limbSwingAmount;
        this.LeftWing.zRot = -0.1308997f + (-0.78726643f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.0f) * limbSwingAmount;
        this.RightFeet.xRot = -(Mth.cos((float)(limbSwing * 1.3324f)) * 0.75f * limbSwingAmount / 2.0f);
        this.LeftFeet.xRot = Mth.cos((float)(limbSwing * 1.3324f)) * 0.75f * limbSwingAmount / 2.0f;
        if (state.isBaby) {
            this.Beak.setPos(0.0f, -2.25f, -3.75f);
        } else {
            this.Beak.setPos(0.0f, -1.75f, -3.75f);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -16.0f, -3.9167f, 10.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)-1.0833f));
        PartDefinition RightFeet = Body.addOrReplaceChild("RightFeet", CubeListBuilder.create().texOffs(54, 10).addBox(-1.0f, -0.5f, -3.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-0.5f, (float)-2.9167f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition LeftFeet = Body.addOrReplaceChild("LeftFeet", CubeListBuilder.create().texOffs(54, 10).mirror().addBox(-1.0f, -0.5f, -3.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)-0.5f, (float)-2.9167f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition LeftWing = Body.addOrReplaceChild("LeftWing", CubeListBuilder.create().texOffs(46, 23).addBox(0.0f, 0.0f, -4.5f, 1.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-14.0f, (float)1.0833f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition RightWing = Body.addOrReplaceChild("RightWing", CubeListBuilder.create().texOffs(46, 23).mirror().addBox(-1.0f, 0.0f, -4.5f, 1.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)-14.0f, (float)1.0833f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 27).addBox(-4.0f, -7.0f, -3.75f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)8.0f, (float)-1.0f));
        PartDefinition Beak = Head.addOrReplaceChild("Beak", CubeListBuilder.create().texOffs(54, 0).addBox(-1.5f, -1.0f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.75f, (float)-3.75f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)42);
    }
}

