/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.client.renderer.state.AncientBlazeRenderState;
import java.util.Arrays;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AncientBlazeModel<T extends AncientBlazeRenderState>
extends AdvancedEntityModel<T> {
    private static final int MAX_SHIELD_COUNT = 4;
    private static final int MAX_STICK_COUNT = 10;
    private final ModelPart Head;
    private final ModelPart Shields;
    private final ModelPart Sticks;
    private final ModelPart[] shields;
    private final ModelPart[] sticks;

    public AncientBlazeModel(ModelPart root) {
        super(root);
        ModelPart body = root.getChild("Body");
        this.Head = body.getChild("Head");
        this.Shields = body.getChild("Shields");
        this.shields = new ModelPart[4];
        Arrays.setAll(this.shields, number -> this.Shields.getChild("shield_" + number));
        this.Sticks = body.getChild("Sticks");
        this.sticks = new ModelPart[10];
        Arrays.setAll(this.sticks, number -> this.Sticks.getChild("stick_" + number));
    }

    @Override
    protected void animate(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int i;
        this.Head.yRot = ((AncientBlazeRenderState)state).yRot * 0.017453f;
        this.Head.xRot = ((AncientBlazeRenderState)state).xRot * 0.017453f;
        float f = 0.785398f + ((AncientBlazeRenderState)state).ageInTicks * -0.094247f;
        for (i = 0; i < this.sticks.length; ++i) {
            this.sticks[i].visible = ((AncientBlazeRenderState)state).shoots > i;
            this.sticks[i].y = Mth.cos((float)(((float)i * 3.0f + ((AncientBlazeRenderState)state).ageInTicks) * 0.3f)) - 1.0f;
            this.sticks[i].x = Mth.cos((float)f) * 9.0f;
            this.sticks[i].z = Mth.sin((float)f) * 9.0f;
            f += 1.0f;
        }
        if (((AncientBlazeRenderState)state).isPowered) {
            this.Shields.yRot = 0.785398f;
            this.Head.y = -22.5f;
            for (i = 0; i < this.shields.length; ++i) {
                this.shields[i].x = Mth.cos((float)((float)i * 1.570796f)) * 6.0f;
                this.shields[i].z = Mth.sin((float)((float)i * 1.570796f)) * 6.0f;
                this.shields[i].xRot = 0.0f;
            }
        } else {
            this.Shields.yRot = -((AncientBlazeRenderState)state).ageInTicks / 50.0f;
            this.Head.y = -24.5f;
            for (i = 0; i < this.shields.length; ++i) {
                this.shields[i].x = Mth.cos((float)((float)i * 1.570796f)) * 7.5f;
                this.shields[i].z = Mth.sin((float)((float)i * 1.570796f)) * 7.5f;
                this.shields[i].xRot = -0.349065f;
            }
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(25, 24).addBox(-2.5f, -22.0f, -2.5f, 5.0f, 35.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-24.5f, (float)0.0f));
        PartDefinition Helmet = Head.addOrReplaceChild("Helmet", CubeListBuilder.create().texOffs(33, 0).addBox(3.5f, -9.5f, -4.5f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(9, 17).addBox(-3.5f, -8.5f, -4.5f, 7.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(9, 22).addBox(-2.5f, -9.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(16, 22).addBox(0.5f, -9.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(23, 22).addBox(-3.5f, -10.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(9, 25).addBox(1.5f, -10.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(16, 25).addBox(0.5f, -11.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(23, 25).addBox(-2.5f, -11.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(9, 28).addBox(-1.5f, -12.5f, -4.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(33, 13).addBox(1.5f, -3.5f, -4.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(40, 13).addBox(-3.5f, -3.5f, -4.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(40, 0).addBox(-4.5f, -9.5f, -4.5f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 33).addBox(-2.5f, -8.5f, 3.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 36).addBox(-2.5f, -0.5f, 3.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(47, 13).addBox(2.5f, -9.5f, 3.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(47, 25).addBox(-3.5f, -9.5f, 3.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 28).addBox(-2.5f, -4.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(33, 19).addBox(-0.5f, -7.5f, 3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 19).addBox(-0.5f, -2.5f, 3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(47, 37).addBox(-1.5f, -6.5f, 3.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(47, 44).addBox(0.5f, -6.5f, 3.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(41, 24).addBox(1.5f, -4.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(52, 29).addBox(3.5f, -1.5f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(52, 21).addBox(3.5f, -8.5f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(52, 13).addBox(-4.5f, -8.5f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(46, 51).addBox(3.5f, -3.5f, -0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 39).addBox(-4.5f, -3.5f, -0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(47, 0).addBox(3.5f, -9.5f, 2.5f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(54, 0).addBox(-4.5f, -9.5f, 2.5f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(7, 40).addBox(-4.5f, -10.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(13, 31).addBox(3.5f, -10.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(13, 34).addBox(3.5f, -5.5f, -1.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 34).addBox(-4.5f, -5.5f, -1.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(46, 55).addBox(3.5f, -5.5f, -0.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(46, 60).addBox(-4.5f, -5.5f, -0.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 37).addBox(-4.5f, -1.5f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(52, 45).addBox(3.5f, -13.5f, -4.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(57, 45).addBox(-4.5f, -13.5f, -4.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(53, 51).addBox(2.5f, -15.5f, -4.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(58, 51).addBox(-3.5f, -15.5f, -4.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Crystal = Head.addOrReplaceChild("Crystal", CubeListBuilder.create().texOffs(25, 2).addBox(-1.5f, -11.5f, -4.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(27, 6).addBox(-3.5f, -9.5f, -4.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(27, 6).addBox(2.5f, -9.5f, -4.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Shields = Body.addOrReplaceChild("Shields", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        CubeListBuilder shieldForm = CubeListBuilder.create().texOffs(0, 43).addBox(-5.0f, 0.0f, -1.0f, 10.0f, 19.0f, 2.0f, new CubeDeformation(0.0f));
        for (int i = 0; i < 4; ++i) {
            Shields.addOrReplaceChild("shield_" + i, shieldForm, PartPose.offsetAndRotation((float)((float)i * 7.5f), (float)0.0f, (float)((float)i * 7.5f), (float)-0.3491f, (float)((float)(0xFFFFFFFF ^ i) * 1.570796f), (float)0.0f));
        }
        PartDefinition Sticks = Body.addOrReplaceChild("Sticks", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        CubeListBuilder stickForm = CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f));
        for (int i = 0; i < 10; ++i) {
            Sticks.addOrReplaceChild("stick_" + i, stickForm, PartPose.offset((float)((float)i * 4.0f), (float)0.0f, (float)((float)i * 4.0f)));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

