/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public abstract class VolumeEntry
extends ListScreenEntryBase<VolumeEntry> {
    protected static final Component OTHER_VOLUME = Component.translatable((String)"message.voicechat.other_volume");
    protected static final Component OTHER_VOLUME_DESCRIPTION = Component.translatable((String)"message.voicechat.other_volume.description");
    protected static final ResourceLocation OTHER_VOLUME_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/other_volume.png");
    protected static final int SKIN_SIZE = 24;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = ARGB.color((int)255, (int)74, (int)74, (int)74);
    protected static final int PLAYER_NAME_COLOR = ARGB.color((int)255, (int)255, (int)255, (int)255);
    protected final Minecraft minecraft = Minecraft.getInstance();
    protected final AdjustVolumesScreen screen;
    protected final AdjustVolumeSlider volumeSlider;

    public VolumeEntry(AdjustVolumesScreen screen, AdjustVolumeSlider.AdjustVolumeEntry entry) {
        this.screen = screen;
        this.volumeSlider = new AdjustVolumeSlider(0, 0, 100, 20, entry);
        this.children.add(this.volumeSlider);
    }

    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
        int left = this.getContentX();
        int top = this.getContentY();
        int width = this.getContentWidth();
        int height = this.getContentHeight();
        int skinX = left + 4;
        int skinY = top + (height - 24) / 2;
        int textX = skinX + 24 + 4;
        Objects.requireNonNull(this.minecraft.font);
        int textY = top + (height - 9) / 2;
        guiGraphics.fill(left, top, left + width, top + height, BG_FILL);
        this.renderElement(guiGraphics, top, left, width, height, mouseX, mouseY, hovered, delta, skinX, skinY, textX, textY);
        this.volumeSlider.setPosition(left + (width - this.volumeSlider.getWidth() - 4), top + (height - this.volumeSlider.getHeight()) / 2);
        this.volumeSlider.render(guiGraphics, mouseX, mouseY, delta);
    }

    public abstract void renderElement(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9, int var10, int var11, int var12, int var13);
}

