/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoofTopNew
extends Block {
    private static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.99, (double)16.0);
    private static final EnumProperty<RoofPart> PART = EnumProperty.create((String)"part", RoofPart.class);

    public RoofTopNew(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)RoofPart.SWITCHED_0)));
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.levelEvent(1029, pos, 0);
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        return BASE;
    }

    private BlockState StairState(BlockState state, LevelReader access, BlockPos pos) {
        boolean north = access.getBlockState(pos.north()).getBlock() == this;
        boolean east = access.getBlockState(pos.east()).getBlock() == this;
        boolean south = access.getBlockState(pos.south()).getBlock() == this;
        boolean west = access.getBlockState(pos.west()).getBlock() == this;
        RoofPart connection = this.getRoofPart(north, east, south, west);
        return (BlockState)state.setValue(PART, (Comparable)((Object)connection));
    }

    private RoofPart getRoofPart(boolean north, boolean east, boolean south, boolean west) {
        if (!north && !south && east && west) {
            return RoofPart.SWITCHED_90;
        }
        if (north && south && east && west) {
            return RoofPart.FOUR_WAY;
        }
        if (north && !south && !east && west) {
            return RoofPart.TOP_OUTER_0;
        }
        if (north && !south && east && !west) {
            return RoofPart.TOP_OUTER_90;
        }
        if (!north && south && east && !west) {
            return RoofPart.TOP_OUTER_180;
        }
        if (!north && south && !east && west) {
            return RoofPart.TOP_OUTER_270;
        }
        if (north && !south && !east && !west) {
            return RoofPart.TOP_END_0;
        }
        if (!north && !south && east && !west) {
            return RoofPart.TOP_END_90;
        }
        if (!north && south && !east && !west) {
            return RoofPart.TOP_END_180;
        }
        if (!north && !south && !east && west) {
            return RoofPart.TOP_END_270;
        }
        if (north && south && east && !west) {
            return RoofPart.THREE_WAY_0;
        }
        if (!north && south && east && west) {
            return RoofPart.THREE_WAY_90;
        }
        if (north && south && !east && west) {
            return RoofPart.THREE_WAY_180;
        }
        if (north && !south && east && west) {
            return RoofPart.THREE_WAY_270;
        }
        return RoofPart.SWITCHED_0;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return this.StairState(state, level, currentPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        BlockPos pos = contx.getClickedPos().below();
        Level world = contx.getLevel();
        BlockState stateBelow = world.getBlockState(pos);
        if (stateBelow.getBlock() instanceof RoofTopNew) {
            return null;
        }
        return this.StairState(super.getStateForPlacement(contx), (LevelReader)world, contx.getClickedPos());
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            level.setBlock(pos, this.StairState(state, (LevelReader)level, pos), 2);
        }
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        RoofPart connection = (RoofPart)((Object)state.getValue(PART));
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            RoofPart newConnection = RoofPart.PYRAMID;
            switch (connection.ordinal()) {
                case 0: {
                    newConnection = RoofPart.SWITCHED_0;
                    break;
                }
                case 1: {
                    newConnection = RoofPart.SWITCHED_90;
                    break;
                }
                case 2: {
                    newConnection = RoofPart.FOUR_WAY;
                    break;
                }
                case 3: {
                    newConnection = RoofPart.TOP_END_0;
                    break;
                }
                case 4: {
                    newConnection = RoofPart.TOP_END_90;
                    break;
                }
                case 5: {
                    newConnection = RoofPart.TOP_END_180;
                    break;
                }
                case 6: {
                    newConnection = RoofPart.TOP_END_270;
                    break;
                }
                case 7: {
                    newConnection = RoofPart.TOP_OUTER_0;
                    break;
                }
                case 8: {
                    newConnection = RoofPart.TOP_OUTER_90;
                    break;
                }
                case 9: {
                    newConnection = RoofPart.TOP_OUTER_180;
                    break;
                }
                case 10: {
                    newConnection = RoofPart.TOP_OUTER_270;
                    break;
                }
                case 11: {
                    newConnection = RoofPart.THREE_WAY_0;
                    break;
                }
                case 12: {
                    newConnection = RoofPart.THREE_WAY_90;
                    break;
                }
                case 13: {
                    newConnection = RoofPart.THREE_WAY_180;
                    break;
                }
                case 14: {
                    newConnection = RoofPart.THREE_WAY_270;
                    break;
                }
                case 15: {
                    newConnection = RoofPart.PYRAMID;
                    break;
                }
            }
            level.setBlock(pos, (BlockState)state.setValue(PART, (Comparable)((Object)newConnection)), 260);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART});
    }

    public void placeAt(Level world, BlockPos pos, int intos) {
        world.setBlock(pos, this.defaultBlockState(), intos);
    }

    public static enum RoofPart implements StringRepresentable
    {
        PYRAMID("pyramid"),
        SWITCHED_0("switched_0"),
        SWITCHED_90("switched_90"),
        FOUR_WAY("four_way"),
        TOP_END_0("top_end_0"),
        TOP_END_90("top_end_90"),
        TOP_END_180("top_end_180"),
        TOP_END_270("top_end_270"),
        TOP_OUTER_0("top_outer_0"),
        TOP_OUTER_90("top_outer_90"),
        TOP_OUTER_180("top_outer_180"),
        TOP_OUTER_270("top_outer_270"),
        THREE_WAY_0("three_way_0"),
        THREE_WAY_90("three_way_90"),
        THREE_WAY_180("three_way_180"),
        THREE_WAY_270("three_way_270");

        private final String name;

        private RoofPart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

