/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.ModelPartInjector;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.OffsetProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Avatar;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AvatarRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, AvatarRenderState, PlayerModel> {
    private boolean setupFirstpersonArms = false;

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel entityModel, float f) {
        super(context, (EntityModel)entityModel, f);
    }

    @Inject(method={"renderHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/model/geom/ModelPart;Z)V"}, at={@At(value="HEAD")})
    private void renderHandStart(PoseStack poseStack, SubmitNodeCollector multiBufferSource, int i, ResourceLocation resourceLocation, ModelPart arm, boolean bl, CallbackInfo info) {
        LocalPlayer abstractClientPlayer = Minecraft.getInstance().player;
        ModelPart sleeve = arm == ((PlayerModel)this.getModel()).leftArm ? ((PlayerModel)this.getModel()).leftSleeve : ((PlayerModel)this.getModel()).rightSleeve;
        PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
        boolean slim = ((PlayerEntityModelAccessor)this.getModel()).hasThinArms();
        ((ModelPartInjector)sleeve).setInjectedMesh(null, null);
        if (!SkinUtil.setup3dLayers((Avatar)abstractClientPlayer, settings, slim)) {
            return;
        }
        this.setupFirstpersonArms = true;
        if (arm == ((PlayerModel)this.getModel()).leftArm) {
            if (SkinLayersModBase.config.enableLeftSleeve) {
                ((ModelPartInjector)sleeve).setInjectedMesh(settings.getLeftArmMesh(), slim ? OffsetProvider.FIRSTPERSON_LEFT_ARM_SLIM : OffsetProvider.FIRSTPERSON_LEFT_ARM);
            }
        } else if (SkinLayersModBase.config.enableRightSleeve) {
            ((ModelPartInjector)sleeve).setInjectedMesh(settings.getRightArmMesh(), slim ? OffsetProvider.FIRSTPERSON_RIGHT_ARM_SLIM : OffsetProvider.FIRSTPERSON_RIGHT_ARM);
        }
    }

    @WrapOperation(method={"lambda$new$0(ZLnet/minecraft/client/model/geom/ModelPart;)Lnet/minecraft/client/model/PlayerModel;"}, at={@At(value="NEW", target="(Lnet/minecraft/client/model/geom/ModelPart;Z)Lnet/minecraft/client/model/PlayerModel;")})
    private static PlayerModel markArmorModelAsIgnored(ModelPart modelPart, boolean slim, Operation<PlayerModel> original) {
        PlayerModel call = (PlayerModel)original.call(new Object[]{modelPart, slim});
        ((PlayerEntityModelAccessor)call).setIgnored(true);
        return call;
    }
}

