/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.apache.commons.lang3.text.WordUtils;

public class StructureUtils {
    public static ListMultimap<ResourceLocation, ResourceLocation> getTypeKeysToStructureKeys(ServerLevel level) {
        ArrayListMultimap typeKeysToStructureKeys = ArrayListMultimap.create();
        for (Structure structure : StructureUtils.getStructureRegistry(level)) {
            typeKeysToStructureKeys.put((Object)StructureUtils.getTypeForStructure(level, structure), (Object)StructureUtils.getKeyForStructure(level, structure));
        }
        return typeKeysToStructureKeys;
    }

    public static Map<ResourceLocation, ResourceLocation> getStructureKeysToTypeKeys(ServerLevel level) {
        HashMap<ResourceLocation, ResourceLocation> structureKeysToStructureKeys = new HashMap<ResourceLocation, ResourceLocation>();
        for (Structure structure : StructureUtils.getStructureRegistry(level)) {
            structureKeysToStructureKeys.put(StructureUtils.getKeyForStructure(level, structure), StructureUtils.getTypeForStructure(level, structure));
        }
        return structureKeysToStructureKeys;
    }

    public static ResourceLocation getTypeForStructure(ServerLevel level, Structure structure) {
        Registry<StructureSet> registry = StructureUtils.getStructureSetRegistry(level);
        for (StructureSet set : registry) {
            for (StructureSet.StructureSelectionEntry entry : set.structures()) {
                if (!((Structure)entry.structure().value()).equals(structure)) continue;
                return registry.getKey((Object)set);
            }
        }
        return ResourceLocation.fromNamespaceAndPath((String)"explorerscompass", (String)"none");
    }

    public static ResourceLocation getKeyForStructure(ServerLevel level, Structure structure) {
        return StructureUtils.getStructureRegistry(level).getKey((Object)structure);
    }

    public static Structure getStructureForKey(ServerLevel level, ResourceLocation key) {
        return (Structure)StructureUtils.getStructureRegistry(level).getValue(key);
    }

    public static Holder<Structure> getHolderForStructure(ServerLevel level, Structure structure) {
        return StructureUtils.getStructureRegistry(level).wrapAsHolder((Object)structure);
    }

    public static List<ResourceLocation> getAllowedStructureKeys(ServerLevel level) {
        ArrayList<ResourceLocation> structures = new ArrayList<ResourceLocation>();
        for (Structure structure : StructureUtils.getStructureRegistry(level)) {
            if (structure == null || StructureUtils.getKeyForStructure(level, structure) == null || StructureUtils.structureIsBlacklisted(level, structure) || StructureUtils.structureIsHidden(level, structure)) continue;
            structures.add(StructureUtils.getKeyForStructure(level, structure));
        }
        return structures;
    }

    public static boolean structureIsBlacklisted(ServerLevel level, Structure structure) {
        List structureBlacklist = (List)ConfigHandler.GENERAL.structureBlacklist.get();
        for (String structureKey : structureBlacklist) {
            if (!StructureUtils.getKeyForStructure(level, structure).toString().matches(StructureUtils.convertToRegex(structureKey))) continue;
            return true;
        }
        return false;
    }

    public static boolean structureIsHidden(ServerLevel level, Structure structure) {
        Registry<Structure> structureRegistry = StructureUtils.getStructureRegistry(level);
        return structureRegistry.wrapAsHolder((Object)structure).tags().anyMatch(tag -> tag.location().getPath().equals("c:hidden_from_locator_selection"));
    }

    public static List<ResourceLocation> getGeneratingDimensionKeys(ServerLevel serverLevel, Structure structure) {
        ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
        for (ServerLevel level : serverLevel.getServer().getAllLevels()) {
            ChunkGenerator chunkGenerator = level.getChunkSource().getGenerator();
            Set biomeSet = chunkGenerator.getBiomeSource().possibleBiomes();
            if (structure.biomes().stream().noneMatch(biomeSet::contains)) continue;
            dimensions.add(level.dimension().location());
        }
        if (structure == StructureType.STRONGHOLD && dimensions.isEmpty()) {
            dimensions.add(ResourceLocation.parse((String)"minecraft:overworld"));
        }
        return dimensions;
    }

    public static ListMultimap<ResourceLocation, ResourceLocation> getGeneratingDimensionsForAllowedStructures(ServerLevel serverLevel) {
        ArrayListMultimap dimensionsForAllowedStructures = ArrayListMultimap.create();
        for (ResourceLocation structureKey : StructureUtils.getAllowedStructureKeys(serverLevel)) {
            Structure structure = StructureUtils.getStructureForKey(serverLevel, structureKey);
            dimensionsForAllowedStructures.putAll((Object)structureKey, StructureUtils.getGeneratingDimensionKeys(serverLevel, structure));
        }
        return dimensionsForAllowedStructures;
    }

    public static int getHorizontalDistanceToLocation(Player player, int x, int z) {
        return StructureUtils.getHorizontalDistanceToLocation(player.blockPosition(), x, z);
    }

    public static int getHorizontalDistanceToLocation(BlockPos startPos, int x, int z) {
        return (int)Mth.sqrt((float)((float)startPos.distSqr((Vec3i)new BlockPos(x, startPos.getY(), z))));
    }

    public static String getPrettyStructureName(ResourceLocation key) {
        String name = key.toString();
        if (((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = I18n.get((String)Util.makeDescriptionId((String)"structure", (ResourceLocation)key), (Object[])new Object[0]);
        }
        if (name.equals(Util.makeDescriptionId((String)"structure", (ResourceLocation)key)) || !((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = key.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    public static String getPrettyStructureSource(ResourceLocation key) {
        if (key == null) {
            return "";
        }
        String registryEntry = key.toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    public static String dimensionKeysToString(List<ResourceLocation> dimensions) {
        HashSet dimensionNames = new HashSet();
        dimensions.forEach(key -> dimensionNames.add(StructureUtils.getDimensionName(key)));
        return String.join((CharSequence)", ", dimensionNames);
    }

    private static String getDimensionName(ResourceLocation dimensionKey) {
        String name = I18n.get((String)Util.makeDescriptionId((String)"dimension", (ResourceLocation)dimensionKey), (Object[])new Object[0]);
        if (name.equals(Util.makeDescriptionId((String)"dimension", (ResourceLocation)dimensionKey))) {
            name = dimensionKey.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    private static Registry<Structure> getStructureRegistry(ServerLevel level) {
        return level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
    }

    private static Registry<StructureSet> getStructureSetRegistry(ServerLevel level) {
        return level.registryAccess().lookupOrThrow(Registries.STRUCTURE_SET);
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

